/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.smyld.gui.event.PageNavigationListener;

public class SMYLDEditorPane
extends JEditorPane {
    private static final long serialVersionUID = 1L;
    PageNavigationListener listener;
    Vector<URL> pages = new Vector();
    int curPos = 0;
    boolean activateNavigation;
    boolean hyperListenerActivated;
    boolean supportExternalLinks = false;

    public SMYLDEditorPane() {
        this.addHyperlinkSupport();
    }

    public SMYLDEditorPane(String url) throws IOException {
        super(url);
        this.setEditable(false);
        this.addHyperlinkSupport();
    }

    public SMYLDEditorPane(String type, String text) throws IOException {
        super(type, text);
        this.addHyperlinkSupport();
    }

    public SMYLDEditorPane(URL page) throws IOException {
        super(page);
        this.setEditable(false);
        this.pages.add(page);
        this.addHyperlinkSupport();
    }

    public void addPageListener(PageNavigationListener newListener) {
        this.listener = newListener;
    }

    public void goBack() {
        if (this.isActivateNavigation() && this.curPos > 0 && this.pages.size() > 0) {
            --this.curPos;
            if (this.goToPage(this.pages.get(this.curPos)) && this.listener != null) {
                this.listener.pageBackwarded(this.pages.get(this.curPos));
            }
        }
    }

    private boolean goToPage(URL pageURL) {
        return this.openPage(pageURL);
    }

    private void setHTMLText(String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append("<body>");
        buffer.append("<p>");
        buffer.append("<b>");
        buffer.append(message);
        buffer.append("</b>");
        buffer.append("</p>");
        buffer.append("</body>");
        buffer.append("</html>");
        this.setContentType("text/html");
        this.setText(buffer.toString());
    }

    public void goForward() {
        if (this.isActivateNavigation() && this.curPos >= 0 && this.pages.size() > 1 && this.curPos != this.pages.size() - 1) {
            ++this.curPos;
            if (this.goToPage(this.pages.get(this.curPos)) && this.listener != null) {
                this.listener.pageForwarded(this.pages.get(this.curPos));
            }
        }
    }

    private void addHyperlinkSupport() {
        if (!this.hyperListenerActivated) {
            try {
                this.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent evt) {
                        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            if (SMYLDEditorPane.this.isExternalLink(evt.getURL()) && !SMYLDEditorPane.this.supportExternalLinks) {
                                try {
                                    Desktop.getDesktop().browse(evt.getURL().toURI());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            } else if (SMYLDEditorPane.this.goToPage(evt.getURL())) {
                                SMYLDEditorPane.this.doAddNewPage(evt.getURL());
                                if (SMYLDEditorPane.this.listener != null) {
                                    SMYLDEditorPane.this.listener.pageNavigated(evt.getURL());
                                }
                            }
                        }
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.hyperListenerActivated = true;
        }
    }

    private boolean isExternalLink(URL link) {
        String lnkText = link.toExternalForm();
        if (lnkText != null && !lnkText.isEmpty()) {
            return lnkText.indexOf("http") != -1 || lnkText.indexOf("https") != -1 || lnkText.indexOf("ftp") != -1;
        }
        return false;
    }

    private void doAddNewPage(URL newPage) {
        if (this.curPos < this.pages.size() - 1) {
            int delPages = this.pages.size() - this.curPos - 1;
            for (int i = 0; i < delPages; ++i) {
                this.pages.remove(this.curPos + 1);
            }
        }
        this.pages.add(newPage);
        this.curPos = this.pages.size() - 1;
    }

    public boolean isActivateNavigation() {
        return this.activateNavigation;
    }

    public void setActivateNavigation(boolean activateNavigation) {
        this.activateNavigation = activateNavigation;
    }

    public boolean openPage(URL page) {
        if (this.isEditable()) {
            this.setEditable(false);
        }
        try {
            this.setContentType("text/html");
            this.addHyperlinkSupport();
            super.setPage(page);
            return true;
        }
        catch (Exception e) {
            this.setHTMLText(e.toString());
            return false;
        }
    }

    public boolean openPage(String page) {
        this.setContentType("text/html");
        if (this.isEditable()) {
            this.setEditable(false);
        }
        try {
            this.addHyperlinkSupport();
            super.setPage(page);
            return true;
        }
        catch (Exception e) {
            this.setHTMLText(e.toString());
            return false;
        }
    }

    public int getHistorySize() {
        return this.pages.size();
    }

    public int getCurrentPageIndexInHistory() {
        return this.curPos;
    }
}

