/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui;

import java.io.File;
import java.util.HashMap;
import javax.swing.filechooser.FileFilter;
import org.smyld.io.FileSystem;

public class SMYLDFileChoosFilter
extends FileFilter {
    String fileDesc;
    HashMap<String, String> fileExts;

    public SMYLDFileChoosFilter(String fileDescription) {
        this.fileDesc = fileDescription;
        this.fileExts = new HashMap();
    }

    public SMYLDFileChoosFilter(String fileExtention, String fileDescription) {
        this(fileDescription);
        this.addExtention(fileExtention);
    }

    public void addExtention(String newExt) {
        if (newExt != null) {
            this.fileExts.put(newExt.toLowerCase(), newExt);
        }
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String fileExt = FileSystem.getExtention((File)f);
        return fileExt != null && this.fileExts.containsKey(fileExt.toLowerCase());
    }

    @Override
    public String getDescription() {
        return this.fileDesc;
    }

    public void setDescription(String newDescription) {
        this.fileDesc = newDescription;
    }
}

