/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui;

import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.smyld.SMYLDObject;
import org.smyld.gui.GUIAction;
import org.smyld.gui.SMYLDButton;
import org.smyld.gui.event.ActionHandler;
import org.smyld.gui.event.SMYLDActionListener;

public class SMYLDMenuObject
extends SMYLDObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    String ID;
    String status;
    GUIAction action;
    ActionHandler handler;
    JMenuItem parentClass;
    SMYLDButton toolbarButton;
    SMYLDActionListener smyldActionListener;
    public static final String STATUS_DISABLED = "Disabled";

    public SMYLDMenuObject(JMenuItem ParentClass, String menuID) {
        this.parentClass = ParentClass;
        this.ID = menuID;
    }

    public SMYLDMenuObject(JMenuItem ParentClass, String menuID, String Status) {
        this(ParentClass, menuID);
        this.status = Status;
        if (this.status != null && this.status.equals(STATUS_DISABLED)) {
            this.parentClass.setEnabled(false);
        }
    }

    public SMYLDMenuObject(JMenuItem ParentClass, String menuID, String Status, String shortKey) {
        this(ParentClass, menuID, Status);
        if (shortKey != null) {
            this.setAccelerator(shortKey);
        }
    }

    public void setActionListener(ActionHandler Handler2) {
        this.handler = Handler2;
        this.processActionHandler();
    }

    private void processActionHandler() {
        boolean wasSet;
        boolean bl = wasSet = this.smyldActionListener != null;
        if (wasSet) {
            this.parentClass.removeActionListener(this.smyldActionListener);
            if (this.toolbarButton != null) {
                this.toolbarButton.removeActionListener(this.smyldActionListener);
            }
        }
        this.smyldActionListener = new SMYLDActionListener(this.handler, this.action);
        this.parentClass.addActionListener(this.smyldActionListener);
        if (this.toolbarButton != null) {
            this.toolbarButton.addActionListener(this.smyldActionListener);
        }
    }

    public JMenuItem getParentClass() {
        return this.parentClass;
    }

    public SMYLDButton getToolbarButton() {
        return this.toolbarButton;
    }

    public void setToolbarIcon(ImageIcon toolbarIcon) {
        this.toolbarButton = new SMYLDButton(toolbarIcon);
        this.toolbarButton.setEnabled(this.parentClass.isEnabled());
    }

    public void setToolbarButton(String lable, ImageIcon toolbarIcon) {
        this.setToolbarIcon(toolbarIcon);
        this.toolbarButton.setText(lable);
    }

    public GUIAction getGUIAction() {
        return this.action;
    }

    public void setGUIAction(GUIAction newAction) {
        this.action = newAction;
        if (this.handler != null) {
            this.processActionHandler();
        }
    }

    public void setAccelerator(String newAccelerator) {
        KeyStroke shortKey = KeyStroke.getKeyStroke(this.validateKey(newAccelerator));
        if (shortKey != null) {
            this.parentClass.setAccelerator(shortKey);
        }
    }

    private String validateKey(String orgKey) {
        if (orgKey == null || orgKey.length() == 0) {
            return null;
        }
        orgKey = orgKey.replace('+', ' ');
        orgKey = orgKey.replaceAll("Ctrl", "ctrl");
        return orgKey;
    }

    public void setTooltipText(String tooltipText) {
        this.parentClass.setToolTipText(tooltipText);
        if (this.toolbarButton != null) {
            this.toolbarButton.setToolTipText(tooltipText);
        }
    }

    public String getID() {
        return this.ID;
    }
}

