/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class SMYLDToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    static final SMYLDToolTipManager sharedInstance = new SMYLDToolTipManager();
    Timer enterTimer = new Timer(750, new insideTimerAction());
    Timer exitTimer;
    Timer insideTimer;
    String toolTipText;
    Point preferredLocation;
    JComponent insideComponent;
    MouseEvent mouseEvent;
    boolean showImmediately = true;
    transient Popup tipWindow;
    private Window window;
    JToolTip tip;
    private Rectangle popupRect = null;
    private Rectangle popupFrameRect = null;
    boolean enabled = true;
    private boolean tipShowing = false;
    private KeyStroke postTip;
    private KeyStroke hideTip;
    private Action postTipAction;
    private Action hideTipAction;
    private FocusListener focusChangeListener = null;
    private MouseMotionListener moveBeforeEnterListener = null;
    protected boolean lightWeightPopupEnabled = true;
    protected boolean heavyWeightPopupEnabled = false;
    JComponent tipComp = null;
    static final int LIGHT_WEIGHT_POPUP = 0;
    static final int MEDIUM_WEIGHT_POPUP = 1;
    static final int HEAVY_WEIGHT_POPUP = 2;

    SMYLDToolTipManager() {
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(500, new outsideTimerAction());
        this.exitTimer.setRepeats(false);
        this.insideTimer = new Timer(4000, new stillInsideTimerAction());
        this.insideTimer.setRepeats(false);
        this.postTip = KeyStroke.getKeyStroke(112, 2);
        this.postTipAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SMYLDToolTipManager.this.tipWindow != null) {
                    SMYLDToolTipManager.this.hideTipWindow();
                    SMYLDToolTipManager.this.insideComponent = null;
                } else {
                    SMYLDToolTipManager.this.hideTipWindow();
                    SMYLDToolTipManager.this.enterTimer.stop();
                    SMYLDToolTipManager.this.exitTimer.stop();
                    SMYLDToolTipManager.this.insideTimer.stop();
                    SMYLDToolTipManager.this.insideComponent = (JComponent)e.getSource();
                    if (SMYLDToolTipManager.this.insideComponent != null) {
                        SMYLDToolTipManager.this.toolTipText = SMYLDToolTipManager.this.insideComponent.getToolTipText();
                        SMYLDToolTipManager.this.preferredLocation = new Point(10, SMYLDToolTipManager.this.insideComponent.getHeight() + 10);
                        SMYLDToolTipManager.this.showTipWindow();
                        if (SMYLDToolTipManager.this.focusChangeListener == null) {
                            SMYLDToolTipManager.this.focusChangeListener = SMYLDToolTipManager.this.createFocusChangeListener();
                        }
                        SMYLDToolTipManager.this.insideComponent.addFocusListener(SMYLDToolTipManager.this.focusChangeListener);
                    }
                }
            }
        };
        this.hideTip = KeyStroke.getKeyStroke(27, 0);
        this.hideTipAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SMYLDToolTipManager.this.hideTipWindow();
                JComponent jc = (JComponent)e.getSource();
                jc.removeFocusListener(SMYLDToolTipManager.this.focusChangeListener);
                SMYLDToolTipManager.this.preferredLocation = null;
                SMYLDToolTipManager.this.insideComponent = null;
            }

            @Override
            public boolean isEnabled() {
                return SMYLDToolTipManager.this.tipShowing;
            }
        };
        this.moveBeforeEnterListener = new MoveBeforeEnterListener();
    }

    public void setEnabled(boolean flag) {
        this.enabled = flag;
        if (!flag) {
            this.hideTipWindow();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setLightWeightPopupEnabled(boolean aFlag) {
        this.lightWeightPopupEnabled = aFlag;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setInitialDelay(int milliseconds) {
        this.enterTimer.setInitialDelay(milliseconds);
    }

    public int getInitialDelay() {
        return this.enterTimer.getInitialDelay();
    }

    public void setDismissDelay(int milliseconds) {
        this.insideTimer.setInitialDelay(milliseconds);
    }

    public int getDismissDelay() {
        return this.insideTimer.getInitialDelay();
    }

    public void setReshowDelay(int milliseconds) {
        this.exitTimer.setInitialDelay(milliseconds);
    }

    public int getReshowDelay() {
        return this.exitTimer.getInitialDelay();
    }

    void showTipWindow() {
        if (this.insideComponent == null || !this.insideComponent.isShowing()) {
            return;
        }
        if (this.enabled) {
            Point screenLocation = this.insideComponent.getLocationOnScreen();
            Point location = new Point();
            Rectangle sBounds = this.insideComponent.getGraphicsConfiguration().getBounds();
            boolean leftToRight = this.insideComponent.getComponentOrientation().isLeftToRight();
            this.hideTipWindow();
            this.tip = this.insideComponent.createToolTip();
            this.tip.setTipText("Hello this is me");
            Dimension size = this.tip.getPreferredSize();
            if (this.preferredLocation != null) {
                location.x = screenLocation.x + this.preferredLocation.x;
                location.y = screenLocation.y + this.preferredLocation.y;
                if (!leftToRight) {
                    location.x -= size.width;
                }
            } else {
                location.x = screenLocation.x + this.mouseEvent.getX();
                location.y = screenLocation.y + this.mouseEvent.getY() + 20;
                if (!leftToRight && location.x - size.width >= 0) {
                    location.x -= size.width;
                }
            }
            if (!this.heavyWeightPopupEnabled) {
                if (this.popupRect == null) {
                    this.popupRect = new Rectangle();
                }
                this.popupRect.setBounds(location.x, location.y, size.width, size.height);
                int y = this.getPopupFitHeight(this.popupRect, this.insideComponent);
                int x = this.getPopupFitWidth(this.popupRect, this.insideComponent);
                if (y > 0) {
                    location.y -= y;
                }
                if (x > 0) {
                    location.x -= x;
                }
            }
            if (location.x < sBounds.x) {
                location.x = sBounds.x;
            } else if (location.x - sBounds.x + size.width > sBounds.width) {
                location.x = sBounds.x + Math.max(0, sBounds.width - size.width);
            }
            if (location.y < sBounds.y) {
                location.y = sBounds.y;
            } else if (location.y - sBounds.y + size.height > sBounds.height) {
                location.y = sBounds.y + Math.max(0, sBounds.height - size.height);
            }
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.tipWindow = popupFactory.getPopup(this.insideComponent, this.tipComp, location.x, location.y);
            this.tipWindow.show();
            Window componentWindow = SwingUtilities.windowForComponent(this.insideComponent);
            this.window = SwingUtilities.windowForComponent(this.tip);
            if (this.window != null && this.window != componentWindow) {
                this.window.addMouseListener(this);
            } else {
                this.window = null;
            }
            this.insideTimer.start();
            this.tipShowing = true;
        }
    }

    void hideTipWindow() {
        if (this.tipWindow != null) {
            if (this.window != null) {
                this.window.removeMouseListener(this);
                this.window = null;
            }
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tipShowing = false;
            this.tip.getUI().uninstallUI(this.tip);
            this.tip = null;
            this.insideTimer.stop();
        }
    }

    public static SMYLDToolTipManager sharedInstance() {
        return sharedInstance;
    }

    public void registerComponent(JComponent component) {
        component.removeMouseListener(this);
        component.addMouseListener(this);
        component.removeMouseMotionListener(this.moveBeforeEnterListener);
        component.addMouseMotionListener(this.moveBeforeEnterListener);
        if (this.shouldRegisterBindings(component)) {
            InputMap inputMap = component.getInputMap(0);
            ActionMap actionMap = component.getActionMap();
            if (inputMap != null && actionMap != null) {
                inputMap.put(this.postTip, "postTip");
                inputMap.put(this.hideTip, "hideTip");
                actionMap.put("postTip", this.postTipAction);
                actionMap.put("hideTip", this.hideTipAction);
            }
        }
    }

    public void unregisterComponent(JComponent component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this.moveBeforeEnterListener);
        if (this.shouldRegisterBindings(component)) {
            InputMap inputMap = component.getInputMap(0);
            ActionMap actionMap = component.getActionMap();
            if (inputMap != null && actionMap != null) {
                inputMap.remove(this.postTip);
                inputMap.remove(this.hideTip);
                actionMap.remove("postTip");
                actionMap.remove("hideTip");
            }
        }
    }

    private boolean shouldRegisterBindings(JComponent component) {
        return true;
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.initiateToolTip(event);
    }

    private void initiateToolTip(MouseEvent event) {
        if (event.getSource() == this.window) {
            return;
        }
        JComponent component = (JComponent)event.getSource();
        component.removeMouseMotionListener(this.moveBeforeEnterListener);
        this.exitTimer.stop();
        Point location = event.getPoint();
        if (location.x < 0 || location.x >= component.getWidth() || location.y < 0 || location.y >= component.getHeight()) {
            return;
        }
        if (this.insideComponent != null) {
            this.enterTimer.stop();
        }
        component.removeMouseMotionListener(this);
        component.addMouseMotionListener(this);
        boolean sameComponent = this.insideComponent == component;
        this.insideComponent = component;
        if (this.tipWindow != null) {
            this.mouseEvent = event;
            if (this.showImmediately) {
                boolean sameLoc;
                String newToolTipText = component.getToolTipText(event);
                Point newPreferredLocation = component.getToolTipLocation(event);
                boolean bl = this.preferredLocation != null ? this.preferredLocation.equals(newPreferredLocation) : (sameLoc = newPreferredLocation == null);
                if (!(sameComponent && this.toolTipText.equals(newToolTipText) && sameLoc)) {
                    this.toolTipText = newToolTipText;
                    this.preferredLocation = newPreferredLocation;
                    this.showTipWindow();
                }
            } else {
                this.enterTimer.start();
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        Window win;
        boolean shouldHide = true;
        if (this.insideComponent == null) {
            // empty if block
        }
        if (this.window != null && event.getSource() == this.window) {
            Container insideComponentWindow = this.insideComponent.getTopLevelAncestor();
            Point location = event.getPoint();
            SwingUtilities.convertPointToScreen(location, this.window);
            location.x -= insideComponentWindow.getX();
            location.y -= insideComponentWindow.getY();
            location = SwingUtilities.convertPoint(null, location, this.insideComponent);
            shouldHide = location.x < 0 || location.x >= this.insideComponent.getWidth() || location.y < 0 || location.y >= this.insideComponent.getHeight();
        } else if (event.getSource() == this.insideComponent && this.tipWindow != null && (win = SwingUtilities.getWindowAncestor(this.insideComponent)) != null) {
            Point location = SwingUtilities.convertPoint(this.insideComponent, event.getPoint(), win);
            Rectangle bounds = this.insideComponent.getTopLevelAncestor().getBounds();
            location.x += bounds.x;
            location.y += bounds.y;
            Point loc = new Point(0, 0);
            SwingUtilities.convertPointToScreen(loc, this.tip);
            bounds.x = loc.x;
            bounds.y = loc.y;
            bounds.width = this.tip.getWidth();
            bounds.height = this.tip.getHeight();
            shouldHide = location.x < bounds.x || location.x >= bounds.x + bounds.width || location.y < bounds.y || location.y >= bounds.y + bounds.height;
        }
        if (shouldHide) {
            this.enterTimer.stop();
            if (this.insideComponent != null) {
                this.insideComponent.removeMouseMotionListener(this);
            }
            this.insideComponent = null;
            this.toolTipText = null;
            this.mouseEvent = null;
            this.hideTipWindow();
            this.exitTimer.restart();
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.hideTipWindow();
        this.enterTimer.stop();
        this.showImmediately = false;
        this.insideComponent = null;
        this.mouseEvent = null;
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.tipShowing) {
            this.checkForTipChange(event);
        } else if (this.showImmediately) {
            JComponent component = (JComponent)event.getSource();
            this.toolTipText = component.getToolTipText(event);
            if (this.toolTipText != null) {
                this.preferredLocation = component.getToolTipLocation(event);
                this.mouseEvent = event;
                this.insideComponent = component;
                this.exitTimer.stop();
                this.showTipWindow();
            }
        } else {
            this.insideComponent = (JComponent)event.getSource();
            this.mouseEvent = event;
            this.toolTipText = null;
            this.enterTimer.restart();
        }
    }

    private void checkForTipChange(MouseEvent event) {
        JComponent component = (JComponent)event.getSource();
        String newText = component.getToolTipText(event);
        Point newPreferredLocation = component.getToolTipLocation(event);
        if (newText != null || newPreferredLocation != null) {
            this.mouseEvent = event;
            if ((newText != null && newText.equals(this.toolTipText) || newText == null) && (newPreferredLocation != null && newPreferredLocation.equals(this.preferredLocation) || newPreferredLocation == null)) {
                if (this.tipWindow != null) {
                    this.insideTimer.restart();
                } else {
                    this.enterTimer.restart();
                }
            } else {
                this.toolTipText = newText;
                this.preferredLocation = newPreferredLocation;
                if (this.showImmediately) {
                    this.hideTipWindow();
                    this.showTipWindow();
                    this.exitTimer.stop();
                } else {
                    this.enterTimer.restart();
                }
            }
        } else {
            this.toolTipText = null;
            this.preferredLocation = null;
            this.mouseEvent = null;
            this.insideComponent = null;
            this.hideTipWindow();
            this.enterTimer.stop();
            this.exitTimer.restart();
        }
    }

    static Frame frameForComponent(Component component) {
        while (!(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    private FocusListener createFocusChangeListener() {
        return new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SMYLDToolTipManager.this.hideTipWindow();
                SMYLDToolTipManager.this.insideComponent = null;
                JComponent c = (JComponent)evt.getSource();
                c.removeFocusListener(SMYLDToolTipManager.this.focusChangeListener);
            }
        };
    }

    private int getPopupFitWidth(Rectangle popupRectInScreen, Component invoker) {
        if (invoker != null) {
            for (Container parent = invoker.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof JFrame || parent instanceof JDialog || parent instanceof JWindow) {
                    return this.getWidthAdjust(parent.getBounds(), popupRectInScreen);
                }
                if (!(parent instanceof JApplet) && !(parent instanceof JInternalFrame)) continue;
                if (this.popupFrameRect == null) {
                    this.popupFrameRect = new Rectangle();
                }
                Point p = parent.getLocationOnScreen();
                this.popupFrameRect.setBounds(p.x, p.y, parent.getBounds().width, parent.getBounds().height);
                return this.getWidthAdjust(this.popupFrameRect, popupRectInScreen);
            }
        }
        return 0;
    }

    private int getPopupFitHeight(Rectangle popupRectInScreen, Component invoker) {
        if (invoker != null) {
            for (Container parent = invoker.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof JFrame || parent instanceof JDialog || parent instanceof JWindow) {
                    return this.getHeightAdjust(parent.getBounds(), popupRectInScreen);
                }
                if (!(parent instanceof JApplet) && !(parent instanceof JInternalFrame)) continue;
                if (this.popupFrameRect == null) {
                    this.popupFrameRect = new Rectangle();
                }
                Point p = parent.getLocationOnScreen();
                this.popupFrameRect.setBounds(p.x, p.y, parent.getBounds().width, parent.getBounds().height);
                return this.getHeightAdjust(this.popupFrameRect, popupRectInScreen);
            }
        }
        return 0;
    }

    private int getHeightAdjust(Rectangle a, Rectangle b) {
        if (b.y >= a.y && b.y + b.height <= a.y + a.height) {
            return 0;
        }
        return b.y + b.height - (a.y + a.height) + 5;
    }

    private int getWidthAdjust(Rectangle a, Rectangle b) {
        if (b.x >= a.x && b.x + b.width <= a.x + a.width) {
            return 0;
        }
        return b.x + b.width - (a.x + a.width) + 5;
    }

    public void setTipComponent(JComponent tipComp) {
        this.tipComp = tipComp;
    }

    private class MoveBeforeEnterListener
    extends MouseMotionAdapter {
        private MoveBeforeEnterListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            SMYLDToolTipManager.this.initiateToolTip(e);
        }
    }

    protected class stillInsideTimerAction
    implements ActionListener {
        protected stillInsideTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SMYLDToolTipManager.this.hideTipWindow();
            SMYLDToolTipManager.this.enterTimer.stop();
            SMYLDToolTipManager.this.showImmediately = false;
            SMYLDToolTipManager.this.insideComponent = null;
            SMYLDToolTipManager.this.mouseEvent = null;
        }
    }

    protected class outsideTimerAction
    implements ActionListener {
        protected outsideTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SMYLDToolTipManager.this.showImmediately = false;
        }
    }

    protected class insideTimerAction
    implements ActionListener {
        protected insideTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.out.println("Inside Times Action ....");
            if (SMYLDToolTipManager.this.insideComponent != null && SMYLDToolTipManager.this.insideComponent.isShowing()) {
                if (SMYLDToolTipManager.this.toolTipText == null && SMYLDToolTipManager.this.mouseEvent != null) {
                    SMYLDToolTipManager.this.toolTipText = SMYLDToolTipManager.this.insideComponent.getToolTipText(SMYLDToolTipManager.this.mouseEvent);
                    SMYLDToolTipManager.this.preferredLocation = SMYLDToolTipManager.this.insideComponent.getToolTipLocation(SMYLDToolTipManager.this.mouseEvent);
                }
                if (SMYLDToolTipManager.this.tipComp != null) {
                    SMYLDToolTipManager.this.showImmediately = true;
                    SMYLDToolTipManager.this.showTipWindow();
                } else {
                    SMYLDToolTipManager.this.insideComponent = null;
                    SMYLDToolTipManager.this.toolTipText = null;
                    SMYLDToolTipManager.this.preferredLocation = null;
                    SMYLDToolTipManager.this.mouseEvent = null;
                    SMYLDToolTipManager.this.hideTipWindow();
                }
            }
        }
    }
}

