/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.smyld.gui.SMYLDPanel;
import org.smyld.gui.event.DragableComponentListener;
import org.smyld.gui.panels.DockableConstants;
import org.smyld.gui.panels.DockablePanel;

public class DockableContainer
extends SMYLDPanel
implements DropTargetListener,
DockableConstants {
    private static final long serialVersionUID = 6564194059413534793L;
    private HashMap<JComponent, JComponent> childComponents = new HashMap();
    private HashMap<JSplitPane, JSplitPane> childSplitters = new HashMap();
    private HashMap<JComponent, DragableComponentListener> draggedComponents = new HashMap();
    private BorderLayout mainLayout = new BorderLayout();
    private Color dropColor = new Color(0, 0, 255, 3);
    private Color dropTxtColor = Color.YELLOW;
    private int location = 0;
    private int dragNo = 1;
    private int margin = 20;
    private int arrowAlpha = 0;
    private int arrowAlphaSign = 1;
    private int lastDropLoc = -1;
    private String dropText = "Drop Panel";
    private JComponent mainComp;
    private JComponent freeComp;
    private Point curPoint;
    private Dimension lastMainCompSize;

    public DockableContainer() {
        this.init();
    }

    private void init() {
        this.setLayout(this.mainLayout);
        this.setDropTarget(new DropTarget(this, this));
        UIDefaults lafDef = UIManager.getLookAndFeelDefaults();
        if (lafDef.getColor("ToolTip.background") != null) {
            this.dropTxtColor = lafDef.getColor("ToolTip.background");
        }
        if (lafDef.getColor("ToolTip.foreground") != null) {
            this.dropColor = lafDef.getColor("ToolTip.foreground");
            this.dropColor = new Color(this.dropColor.getRed(), this.dropTxtColor.getGreen(), this.dropTxtColor.getBlue(), 4);
        }
    }

    public void registerDragOperation(DragableComponentListener draggedCompListner) {
        this.draggedComponents.put(draggedCompListner.getComponent(), draggedCompListner);
    }

    public void dropComponent(JComponent dropComp) {
        if (this.draggedComponents.containsKey(dropComp) && this.location != 0) {
            DragableComponentListener listener = this.draggedComponents.get(dropComp);
            this.draggedComponents.remove(dropComp);
            this.setLastMainComponent(dropComp);
            this.removeComponent(dropComp);
            this.revalidate();
            this.addComponent(dropComp, this.location, !listener.isInternal());
        } else {
            this.cancel();
        }
    }

    private void setLastMainComponent(JComponent dropComp) {
        if (this.mainComp instanceof JSplitPane) {
            JSplitPane split = (JSplitPane)this.mainComp;
            Component lastMain = null;
            if (dropComp.equals(split.getLeftComponent())) {
                lastMain = split.getRightComponent();
            } else if (dropComp.equals(split.getRightComponent())) {
                lastMain = split.getLeftComponent();
            } else if (dropComp.equals(split.getTopComponent())) {
                lastMain = split.getBottomComponent();
            } else if (dropComp.equals(split.getBottomComponent())) {
                lastMain = split.getTopComponent();
            }
            this.lastMainCompSize = lastMain.getPreferredSize();
        } else {
            this.lastMainCompSize = this.mainComp.getPreferredSize();
        }
    }

    public void setFreeMainComponent(JComponent freeComp) {
        if (this.mainComp instanceof JSplitPane) {
            JSplitPane split = (JSplitPane)this.mainComp;
            Object lastMain = null;
            if (this.isNotFree(split.getLeftComponent())) {
                split.setLeftComponent(freeComp);
            } else if (this.isNotFree(split.getRightComponent())) {
                split.setRightComponent(freeComp);
            } else if (this.isNotFree(split.getTopComponent())) {
                split.setTopComponent(freeComp);
            } else if (this.isNotFree(split.getBottomComponent())) {
                split.setBottomComponent(freeComp);
            }
        }
    }

    private boolean isNotFree(Component comp) {
        return !(comp instanceof JSplitPane) && !(comp instanceof DockablePanel);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    private boolean isLocalDragable(Object dragObj) {
        if (dragObj instanceof JComponent) {
            return this.draggedComponents.containsKey(dragObj);
        }
        return false;
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.curPoint = dtde.getLocation();
        if (this.curPoint.x <= this.margin) {
            this.paintDrop(0, 0, this.margin, this.getHeight(), 1);
            return;
        }
        if (this.curPoint.y <= this.margin) {
            this.paintDrop(0, 0, this.getWidth(), this.margin, 2);
            return;
        }
        if (this.getHeight() - this.curPoint.y <= this.margin) {
            this.paintDrop(0, this.getHeight() - this.margin, this.getWidth(), this.getHeight(), 4);
            return;
        }
        if (this.getWidth() - this.curPoint.x <= this.margin) {
            this.paintDrop(this.getWidth() - this.margin, 0, this.getWidth(), this.getHeight(), 3);
            return;
        }
        if (this.location != 0) {
            this.cancel();
        }
    }

    private void paintDrop(int x, int y, int width, int height, int loc) {
        if (this.location != loc) {
            this.cancel();
        }
        this.location = loc;
        Graphics2D g = (Graphics2D)this.getGraphics();
        g.setColor(this.dropColor);
        g.fillRect(x, y, width, height);
        int smargin = this.margin / 5;
        g.setColor(this.dropTxtColor);
        switch (this.location) {
            case 1: {
                int fArcX = x + 4 * smargin;
                int fArcY = y + 2 * smargin;
                int[] xarray1 = new int[]{fArcX, fArcX, fArcX - 3 * smargin, fArcX};
                int[] yarray1 = new int[]{fArcY, fArcY + 3 * smargin, (int)((double)fArcY + 1.5 * (double)smargin), fArcY};
                g.fillPolygon(xarray1, yarray1, 3);
                fArcX = x + 4 * smargin;
                fArcY = height - 2 * smargin;
                int[] xarray2 = new int[]{fArcX, fArcX, fArcX - 3 * smargin, fArcX};
                int[] yarray2 = new int[]{fArcY, fArcY - 3 * smargin, (int)((double)fArcY - 1.5 * (double)smargin), fArcY};
                g.fillPolygon(xarray2, yarray2, 3);
                break;
            }
            case 2: {
                int fArcX = x + 2 * smargin;
                int fArcY = y + 4 * smargin;
                int[] xarray3 = new int[]{fArcX, fArcX + 3 * smargin, (int)((double)fArcX + 1.5 * (double)smargin), fArcX};
                int[] yarray3 = new int[]{fArcY, fArcY, fArcY - 3 * smargin, fArcY};
                g.fillPolygon(xarray3, yarray3, 3);
                fArcX = width - 2 * smargin;
                fArcY = y + 4 * smargin;
                int[] xarray4 = new int[]{fArcX, fArcX - 3 * smargin, (int)((double)fArcX - 1.5 * (double)smargin), fArcX};
                int[] yarray4 = new int[]{fArcY, fArcY, fArcY - 3 * smargin, fArcY};
                g.fillPolygon(xarray4, yarray4, 3);
                break;
            }
            case 4: {
                int fArcX = x + 2 * smargin;
                int fArcY = y + 1 * smargin;
                int[] xarray5 = new int[]{fArcX, fArcX + 3 * smargin, (int)((double)fArcX + 1.5 * (double)smargin), fArcX};
                int[] yarray5 = new int[]{fArcY, fArcY, fArcY + 3 * smargin, fArcY};
                g.fillPolygon(xarray5, yarray5, 3);
                fArcX = width - 2 * smargin;
                fArcY = y + 1 * smargin;
                int[] xarray6 = new int[]{fArcX, fArcX - 3 * smargin, (int)((double)fArcX - 1.5 * (double)smargin), fArcX};
                int[] yarray6 = new int[]{fArcY, fArcY, fArcY + 3 * smargin, fArcY};
                g.fillPolygon(xarray6, yarray6, 3);
                break;
            }
            case 3: {
                int fArcX = x + 1 * smargin;
                int fArcY = y + 1 * smargin;
                int[] xarray7 = new int[]{fArcX, fArcX, fArcX + 3 * smargin, fArcX};
                int[] yarray7 = new int[]{fArcY, fArcY + 3 * smargin, (int)((double)fArcY + 1.5 * (double)smargin), fArcY};
                g.fillPolygon(xarray7, yarray7, 3);
                fArcX = width - 4 * smargin;
                fArcY = height - 1 * smargin;
                int[] xarray8 = new int[]{fArcX, fArcX, fArcX + 3 * smargin, fArcX};
                int[] yarray8 = new int[]{fArcY, fArcY - 3 * smargin, (int)((double)fArcY - 1.5 * (double)smargin), fArcY};
                g.fillPolygon(xarray8, yarray8, 3);
            }
        }
        int rotate = 0;
        int textX = (x + width) / 2;
        int textY = (y + height) / 2;
        if (loc == 1 || loc == 3) {
            rotate = 270;
            textX += this.margin / 5;
        } else {
            textY += this.margin / 5;
        }
        g.setPaintMode();
        Font targetFont = new Font("Arial", 3, 12);
        g.getFontRenderContext().getTransform().translate(textX, textY);
        g.rotate(Math.toRadians(rotate), textX, textY);
        g.setFont(targetFont);
        g.drawString(this.getDropText(), textX, textY);
    }

    private void cancel() {
        this.location = 0;
        this.repaint();
    }

    private Polygon createTraingle(int x, int y, int length) {
        int[] xarray = new int[]{x, x - length, x - length / 2, x};
        int[] yarray = new int[]{y, y, y + length, y};
        return new Polygon(xarray, yarray, 3);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.cancel();
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
    }

    public void addSideComponent(JComponent newComponent) {
        if (this.getComponentOrientation().isLeftToRight()) {
            this.addComponent(newComponent, 1, false);
        } else {
            this.addComponent(newComponent, 3, false);
        }
    }

    public void addDownComponent(JComponent newComponent) {
        this.addComponent(newComponent, 4, false);
    }

    public void setFreeComponent(JComponent newComp) {
        this.freeComp = newComp;
        this.revalidate();
        this.repaint();
    }

    public void addComponent(JComponent newComponent, int toLocation, boolean extendSize) {
        if (!this.childComponents.containsKey(newComponent)) {
            this.childComponents.put(newComponent, newComponent);
        }
        if (newComponent instanceof DockablePanel) {
            ((DockablePanel)newComponent).setDockLocation(toLocation);
        }
        JSplitPane newSplit = new JSplitPane(1);
        newSplit.setComponentOrientation(this.getComponentOrientation());
        Dimension compSize = newComponent.getPreferredSize();
        if (this.lastMainCompSize == null) {
            this.setLastMainComponent(newComponent);
        }
        Dimension origSize = this.mainComp.getPreferredSize();
        switch (toLocation) {
            case 1: {
                newSplit.setLeftComponent(newComponent);
                newSplit.setRightComponent(this.mainComp);
                newSplit.setDividerLocation(newComponent.getPreferredSize().width);
                this.mainComp = newSplit;
                this.add((Component)this.mainComp, "Center");
                break;
            }
            case 2: {
                newSplit.setOrientation(0);
                if (!extendSize) {
                    newSplit.setResizeWeight(0.0);
                }
                newSplit.setTopComponent(newComponent);
                newSplit.setBottomComponent(this.mainComp);
                if (extendSize) {
                    newSplit.setDividerLocation(newComponent.getPreferredSize().height);
                }
                this.mainComp = newSplit;
                this.add((Component)this.mainComp, "Center");
                break;
            }
            case 4: {
                newSplit.setOrientation(0);
                if (!extendSize) {
                    newSplit.setResizeWeight(1.0);
                }
                newSplit.setTopComponent(this.mainComp);
                newSplit.setBottomComponent(newComponent);
                if (extendSize) {
                    newSplit.setDividerLocation(newSplit.getHeight() - newComponent.getPreferredSize().height);
                }
                this.mainComp = newSplit;
                this.add((Component)this.mainComp, "Center");
                break;
            }
            case 3: {
                newSplit.setLeftComponent(this.mainComp);
                if (!extendSize) {
                    newSplit.setResizeWeight(1.0);
                }
                newSplit.setRightComponent(newComponent);
                newSplit.setDividerLocation(this.mainComp.getWidth());
                this.mainComp = newSplit;
                this.add((Component)this.mainComp, "Center");
            }
        }
        if (extendSize) {
            this.handelSize(newComponent, toLocation, compSize, this.lastMainCompSize);
            Component window = this.getPanelWindow();
            if (window != null) {
                window.setSize(this.getSize());
                switch (toLocation) {
                    case 3: {
                        if (this.lastDropLoc != 1) break;
                        window.setLocation(window.getLocation().x + compSize.width, window.getLocation().y);
                        break;
                    }
                    case 4: {
                        if (this.lastDropLoc != 1) break;
                        window.setLocation(window.getLocation().x + compSize.width, window.getLocation().y);
                        break;
                    }
                    case 1: {
                        window.setLocation(window.getLocation().x - compSize.width, window.getLocation().y);
                        break;
                    }
                    case 2: {
                        int newX = window.getLocation().x;
                        if (this.lastDropLoc == 1) {
                            newX = window.getLocation().x + compSize.width;
                        }
                        window.setLocation(newX, window.getLocation().y - compSize.height);
                    }
                }
                this.lastDropLoc = this.location;
            }
        }
        this.childSplitters.put(newSplit, newSplit);
        this.validate();
        this.repaint();
    }

    private void handelSize(JComponent newComp, int location, Dimension compSize, Dimension origSize) {
        int newHeight = origSize.height;
        int newWidth = origSize.width;
        System.out.println("Main Component (W:" + origSize.width + " , H:" + origSize.height);
        System.out.println("Drag Component (W:" + compSize.width + " , H:" + compSize.height);
        switch (location) {
            case 1: 
            case 3: {
                newWidth = origSize.width + compSize.width;
                newHeight = origSize.height > compSize.height ? origSize.height : compSize.height;
                break;
            }
            case 2: 
            case 4: {
                newHeight = origSize.height + compSize.height;
                newWidth = origSize.width > compSize.width ? origSize.width : compSize.width;
            }
        }
        this.setSize(newWidth, newHeight);
    }

    public JComponent getMainComp() {
        return this.mainComp;
    }

    public void setMainComp(JComponent mainComp) {
        if (!(mainComp instanceof JSplitPane)) {
            this.freeComp = mainComp;
        }
        this.mainComp = mainComp;
        this.add((Component)mainComp, "Center");
    }

    public void removeComponent(JComponent targetComponent) {
        if (this.childComponents.containsKey(targetComponent)) {
            JSplitPane targetSplitter = (JSplitPane)targetComponent.getParent();
            Container splitCont = targetSplitter.getParent();
            JComponent remainComponent = null;
            if (this.childSplitters.containsKey(targetSplitter)) {
                int spiltterOrient = targetSplitter.getOrientation();
                if (spiltterOrient == 1) {
                    JComponent rcomp = (JComponent)targetSplitter.getRightComponent();
                    JComponent lcomp = (JComponent)targetSplitter.getLeftComponent();
                    splitCont.remove(targetSplitter);
                    if (targetComponent.equals(rcomp)) {
                        splitCont.add(lcomp);
                        remainComponent = lcomp;
                    } else {
                        splitCont.add(rcomp);
                        remainComponent = rcomp;
                    }
                } else if (spiltterOrient == 0) {
                    JComponent tcomp = (JComponent)targetSplitter.getTopComponent();
                    JComponent bcomp = (JComponent)targetSplitter.getBottomComponent();
                    splitCont.remove(targetSplitter);
                    if (targetComponent.equals(tcomp)) {
                        splitCont.add(bcomp);
                        remainComponent = bcomp;
                    } else {
                        splitCont.add(tcomp);
                        remainComponent = tcomp;
                    }
                }
            }
            if (this.mainComp.equals(targetSplitter)) {
                this.mainComp = remainComponent;
            }
            this.childComponents.remove(targetComponent);
            this.childSplitters.remove(targetSplitter);
        }
    }

    public String getDropText() {
        return this.dropText;
    }

    public void setDropText(String dropText) {
        this.dropText = dropText;
    }
}

