/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.gui.panels;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.smyld.gui.event.DragableComponentListener;
import org.smyld.gui.panels.DockablePanel;
import org.smyld.resources.Resource;

public class DockablePanelTransferHandler
extends TransferHandler
implements Transferable {
    private static final long serialVersionUID = 1L;
    DockablePanel draggedPanel;
    DragableComponentListener dragListener;
    DataFlavor panelDF;

    public DockablePanelTransferHandler(DockablePanel component) {
        this.draggedPanel = component;
        this.panelDF = new DataFlavor(component.getClass(), "SMYLD Dockable Panel");
    }

    public DockablePanelTransferHandler(DragableComponentListener dragListener) {
        this.dragListener = dragListener;
        this.panelDF = new DataFlavor(dragListener.getComponent().getClass(), "SMYLD Dockable Panel");
    }

    @Override
    public Transferable createTransferable(JComponent comp) {
        return this;
    }

    @Override
    public boolean importData(JComponent comp, Transferable transferable) {
        return true;
    }

    @Override
    public int getSourceActions(JComponent comp) {
        return 3;
    }

    @Override
    public void exportDone(JComponent comp, Transferable transfer, int action) {
        this.draggedPanel.dragEnded();
        this.dragListener.dragEnded();
    }

    @Override
    public Icon getVisualRepresentation(Transferable t) {
        return new Resource().getImageIcon("parser_sm.gif");
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent evt, int action) {
        this.dragListener.dragStarted();
        super.exportAsDrag(this.dragListener.getComponent(), evt, action);
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] dfs) {
        return true;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] response = new DataFlavor[]{this.panelDF};
        return response;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.panelDF.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        return this.dragListener.getComponent();
    }
}

