/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.lang.script.java;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.smyld.lang.script.util.Method;
import org.smyld.text.TextUtil;

public class JavaMethod
extends Method {
    private static final long serialVersionUID = 1L;
    HashMap<String, String> exceptions;
    boolean withBody;
    boolean isConstructor = false;
    public static final String RETURN_TYPE_VOID = "void";

    public JavaMethod(String Name, String Scope, String ReturnType) {
        super(Name, Scope, ReturnType);
    }

    public JavaMethod(String Name, String Scope, String ReturnType, boolean Construtor) {
        this(Name, Scope, ReturnType);
        this.isConstructor = Construtor;
    }

    @Override
    public void addModifier(String newModifier) {
        if (!newModifier.equals("final")) {
            super.addModifier(newModifier);
        }
    }

    @Override
    public boolean parseMethod(String codeLine) {
        return false;
    }

    public void addExceptionThrowing(String exceptionClass) {
        if (this.exceptions == null) {
            this.exceptions = new HashMap();
        }
        this.exceptions.put(exceptionClass, exceptionClass);
    }

    @Override
    public String print(int tabSeq) {
        String margin = null;
        if (tabSeq > 0) {
            margin = TextUtil.createWord((String)"\t", (int)tabSeq);
        }
        this.body.setLength(0);
        this.body.append(margin + this.scope + " ");
        this.fillInModifiers();
        if (!this.isConstructor) {
            if (this.returnType == null) {
                this.returnType = RETURN_TYPE_VOID;
            }
            this.body.append(this.returnType + " ");
        }
        this.body.append(this.name);
        this.body.append("(");
        this.fillInParameters();
        this.body.append(")");
        if (this.exceptions != null && this.exceptions.size() > 0) {
            this.body.append("throws ");
            Iterator<String> itr = this.exceptions.values().iterator();
            while (itr.hasNext()) {
                this.body.append(itr.next());
                if (!itr.hasNext()) continue;
                this.body.append(",");
            }
        }
        if (this.modifiers.containsKey("abstract")) {
            this.body.append(";");
        } else {
            this.adjustCodeLines();
            ++tabSeq;
            this.body.append("{\n");
            if (this.codeLines.size() > 0) {
                for (String currentLineCode : this.codeLines) {
                    if (this.isBlockEnd(currentLineCode.trim())) {
                        --tabSeq;
                    }
                    margin = TextUtil.createWord((String)"\t", (int)tabSeq);
                    if (this.isBlockStart(currentLineCode.trim())) {
                        ++tabSeq;
                    }
                    this.body.append(margin + currentLineCode);
                    if (this.isLineEnd(currentLineCode.trim())) {
                        this.body.append(";");
                    }
                    this.body.append("\n");
                }
            }
            margin = TextUtil.createWord((String)"\t", (int)(--tabSeq));
            this.body.append(margin + "}\n");
        }
        return this.body.toString();
    }

    private int getLongestEquation() {
        int equalIndex = 0;
        for (String currentLineCode : this.codeLines) {
            if (currentLineCode == null || equalIndex >= currentLineCode.indexOf("=")) continue;
            equalIndex = currentLineCode.indexOf("=");
        }
        return equalIndex;
    }

    private int getLongestNew() {
        int newIndex = 0;
        int bracketIndex = 0;
        for (String currentLineCode : this.codeLines) {
            newIndex = currentLineCode.indexOf("new ");
            if (newIndex == -1 || bracketIndex >= currentLineCode.indexOf("(")) continue;
            bracketIndex = currentLineCode.indexOf("(");
        }
        return bracketIndex;
    }

    private void adjustCodeLines() {
        Vector<String> bufferLines = new Vector<String>(this.codeLines.size());
        String currentLineCode = null;
        int longestCode = this.getLongestEquation();
        for (int i = 0; i < this.codeLines.size(); ++i) {
            currentLineCode = (String)this.codeLines.get(i);
            if (this.isAdjustable(currentLineCode)) {
                currentLineCode = this.allignCodeLine(currentLineCode, longestCode, "=");
            }
            bufferLines.add(i, currentLineCode);
        }
        this.codeLines = bufferLines;
        bufferLines = new Vector(this.codeLines.size());
        int longestNew = this.getLongestNew();
        for (int i = 0; i < this.codeLines.size(); ++i) {
            currentLineCode = (String)this.codeLines.get(i);
            if (this.isAdjustable(currentLineCode)) {
                currentLineCode = this.allignCodeLine(currentLineCode, longestNew, "(");
            }
            bufferLines.add(i, currentLineCode);
        }
        this.codeLines = bufferLines;
    }

    private boolean isAdjustable(String codeLine) {
        return codeLine.indexOf("=") != -1 && codeLine.indexOf("new ") != -1;
    }

    private String allignCodeLine(String codeLine, int longIndex, String offsetText) {
        StringBuffer buffer = new StringBuffer();
        int currentIndex = codeLine.indexOf(offsetText);
        if (currentIndex != -1 && longIndex > currentIndex) {
            buffer.append(codeLine.substring(0, currentIndex));
            buffer.append(TextUtil.createWord((char)' ', (int)(longIndex - currentIndex)));
            buffer.append(offsetText);
            buffer.append(codeLine.substring(currentIndex + 1));
            codeLine = buffer.toString();
        }
        return codeLine;
    }

    private boolean isLineEnd(String lineCode) {
        return !lineCode.endsWith("}") && !lineCode.endsWith("{") && !lineCode.endsWith(":");
    }

    private boolean isBlockStart(String lineCode) {
        return lineCode.endsWith("{");
    }

    private boolean isBlockEnd(String lineCode) {
        return lineCode.endsWith("}") || lineCode.endsWith("})");
    }
}

