/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.lang.script.util;

import java.util.Vector;
import org.smyld.SMYLDObject;
import org.smyld.lang.script.util.Expression;
import org.smyld.text.MultiTextPatternTockenizer;

public abstract class BooleanExpression
extends SMYLDObject {
    protected Vector<Expression> conditions = new Vector();
    protected String text;
    protected String[] condsSep;
    protected String[] singleCondSep;
    protected MultiTextPatternTockenizer condsTocken = new MultiTextPatternTockenizer(this.getSeparators(), true);

    public BooleanExpression() {
        this.condsTocken.setPattern("(", ")");
    }

    public BooleanExpression(String Text) {
        this();
        this.text = Text.trim();
    }

    public boolean isMultiCondition(String condText) {
        return false;
    }

    public abstract String[] getSeparators();

    public void parseText() {
        if (this.conditions.size() > 0) {
            this.conditions.removeAllElements();
        }
        this.parseConditions(this.text, this.conditions, null);
        if (this.conditions.size() == 0) {
            this.conditions.add(new Expression("0", null, this.text, null));
        }
    }

    private void parseConditions(String text, Vector<Expression> currentConditions, String parentID) {
        String currentID = null;
        String[] conds = null;
        this.condsTocken.setText(text);
        conds = this.condsTocken.parseTokens();
        for (int i = 0; i < conds.length; i += 2) {
            if (i == 0) {
                currentID = "0";
                currentConditions.add(new Expression(currentID, parentID, conds[i].toString(), null));
            } else {
                currentID = Integer.toString(i - 1);
                currentConditions.add(new Expression(currentID, parentID, conds[i].toString(), conds[i - 1].toString()));
            }
            if (!this.isMultiCondition(conds[i].toString())) continue;
            this.parseConditions(conds[i].toString(), currentConditions, currentID);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        this.text = newText;
    }
}

