/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.lang.script.converter;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.smyld.lang.script.converter.Converter;
import org.smyld.lang.script.java.JavaConstants;
import org.smyld.lang.script.vb.VBCodeReader;
import org.smyld.lang.script.vb.VBScriptlet;

public class VBtoJavaConverter
extends Converter
implements JavaConstants {
    private static final long serialVersionUID = 5779548698205738999L;
    VBScriptlet vbSrcScript;
    boolean insideFunction = false;
    HashMap<String, String> reservedKeywords = new HashMap();
    StringBuffer buffer = new StringBuffer();

    public VBtoJavaConverter() {
        this.vbSrcScript = new VBScriptlet();
        this.reservedKeywords.put("<>", "!=");
        this.reservedKeywords.put("=", "==");
        this.reservedKeywords.put("not", "!");
        this.reservedKeywords.put("and", "&&");
        this.reservedKeywords.put("or", "||");
    }

    @Override
    public void loadCodeFile(String fileName) throws IOException {
        this.currentCodeReader = new VBCodeReader(new File(fileName));
    }

    @Override
    public void loadCodeText(String codeText) throws IOException {
        this.currentCodeReader = new VBCodeReader(codeText);
    }

    @Override
    public void doConvert(String currentLine) {
        System.out.println(currentLine);
        System.out.println("Type : " + this.vbSrcScript.getCodeLineType(currentLine));
        switch (this.vbSrcScript.getCodeLineType(currentLine)) {
            case 6: {
                break;
            }
            case 2: 
            case 4: {
                this.vbSrcScript.doParseFunction(currentLine);
                this.insideFunction = true;
                break;
            }
        }
    }

    private void transferToJava(String[] elements) {
        this.buffer.setLength(0);
        int bracketsNO = 1;
        this.buffer.append("(");
        for (int i = 0; i < elements.length; ++i) {
            if (this.reservedKeywords.containsKey(elements[i])) {
                elements[i] = this.reservedKeywords.get(elements[i]);
            }
            if (elements[i].equals("&&") || elements[i].equals("||")) {
                this.buffer.append(")");
                this.buffer = this.buffer.insert(0, "(");
                this.buffer.append(elements[i]);
                this.buffer.append("(");
                ++bracketsNO;
                continue;
            }
            this.buffer.append(elements[i]);
        }
        for (int j = 0; j < bracketsNO; ++j) {
            this.buffer.append(")");
        }
    }

    public static HashMap<String, String> convertModifiers(HashMap<String, String> modifiers) {
        HashMap<String, String> javaModifiers = new HashMap<String, String>();
        for (String curModifier : modifiers.values()) {
            if (!curModifier.equals("const")) continue;
            javaModifiers.put("static", "static");
            javaModifiers.put("final", "final");
        }
        return javaModifiers;
    }

    public static String convertType(String vbType) {
        if (vbType.toLowerCase().equals("integer")) {
            return "int";
        }
        if (vbType.toLowerCase().equals("long")) {
            return "long";
        }
        if (vbType.toLowerCase().equals("boolean")) {
            return "boolean";
        }
        if (vbType.toLowerCase().equals("byte")) {
            return "byte";
        }
        return vbType;
    }

    @Override
    public String getSourceLangDelimiter() {
        return null;
    }
}

