/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.lang.script.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.smyld.lang.script.util.Parameter;
import org.smyld.lang.script.util.Variable;
import org.smyld.text.TextTokenizer;

public abstract class Method
extends Variable {
    protected String returnType;
    HashMap<String, String> parametersKeys;
    Vector<Parameter> parameters;
    protected Vector<String> codeLines = new Vector();

    public Method() {
    }

    public Method(String Name) {
        super(Name);
    }

    public Method(String Name, String Scope) {
        super(Name, Scope);
    }

    public void addCodeLine(String newCodeLine) {
        if (newCodeLine != null) {
            this.codeLines.add(newCodeLine);
        }
    }

    public void addPrintingLineCode(String newCodeLine) {
        if (newCodeLine != null) {
            this.codeLines.add("System.out.println(\"" + newCodeLine + "\")");
        }
    }

    public void addCodeLines(Vector<String> newCodeLines) {
        for (String currentCodeLine : newCodeLines) {
            this.addCodeLine(currentCodeLine);
        }
    }

    public Method(String Name, String Scope, String ReturnType) {
        this(Name, Scope);
        this.returnType = ReturnType;
    }

    public String[] exctractParameters(String codeLine) {
        int begin = codeLine.indexOf("(");
        int end = codeLine.indexOf(")");
        if (begin != -1 && end != -1) {
            return new TextTokenizer(codeLine.substring(begin + 1, end), ",").parseTokens();
        }
        return null;
    }

    public String[] exctractDefinitionPart(String codeLine) {
        int begin = codeLine.indexOf("(");
        if (begin != -1) {
            return new TextTokenizer(codeLine.substring(0, begin), " ").parseTokens();
        }
        return null;
    }

    public void fillInParameters() {
        if (this.parameters != null && this.parameters.size() > 0) {
            Iterator<Parameter> parms = this.parameters.iterator();
            while (parms.hasNext()) {
                Parameter currentParameter = parms.next();
                String paramName = currentParameter.getName();
                String paramType = currentParameter.getType();
                this.body.append(this.fillParameter(paramName, paramType));
                if (!parms.hasNext()) continue;
                this.body.append(",");
            }
        }
    }

    public String fillParameter(String name, String type) {
        return type + " " + name;
    }

    public void addParameter(String parameterName, String parameterType) {
        if (this.parametersKeys == null) {
            this.parametersKeys = new HashMap();
            this.parameters = new Vector();
        }
        if (!this.parametersKeys.containsKey(parameterName)) {
            this.parametersKeys.put(parameterName, parameterName);
            this.parameters.add(new Parameter(parameterName, parameterType));
        }
    }

    @Override
    public String print() {
        return super.print();
    }

    public String print(int tabSeq) {
        return super.print();
    }

    public abstract boolean parseMethod(String var1);
}

