/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.lang.script.java;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.smyld.lang.script.java.JavaLangUtility;
import org.smyld.lang.script.java.JavaMethod;
import org.smyld.lang.script.java.JavaVariable;
import org.smyld.lang.script.util.ClassBody;
import org.smyld.lang.script.util.Variable;
import org.smyld.text.TextUtil;

public class JavaClassBody
extends ClassBody {
    private static final long serialVersionUID = 1L;
    protected Vector<JavaMethod> constructors = new Vector();
    protected HashMap<String, String> imports = new HashMap();
    protected HashSet<String> interfaces = new HashSet();
    protected String parentClass;
    protected boolean isPublic;
    boolean isAbstract;
    public static final String SCOPE_PUBLIC = "public";
    public static final String SCOPE_PRIVATE = "private";
    public static final String SCOPE_PROTECTED = "protected";
    public static final String MODIFIER_STATIC = "static";
    public static final String MODIFIER_SYNCHRONIZED = "synchronized";
    public static final String MODIFIER_FINAL = "final";
    public static final String MODIFIER_ABSTRACT = "abstract";
    public static final String KEYWORD_PACKAGE = "package";
    public static final String KEYWORD_CLASS = "class";
    public static final String KEYWORD_INTERFACE = "interface";
    public static final String KEYWORD_EXTENDS = "extends";
    public static final String KEYWORD_IMPLEMENTS = "implements";
    public static final String KEYWORD_IMPORT = "import";

    public JavaClassBody() {
        this.extension = "java";
    }

    public JavaClassBody(String Name) {
        super(Name);
        this.extension = "java";
    }

    public JavaClassBody(String Name, boolean Public, boolean Abstract) {
        this(Name);
        this.isPublic = Public;
        this.isAbstract = Abstract;
    }

    public JavaClassBody(String Name, String PackageName, boolean Public, boolean Abstract) {
        this(Name, Public, Abstract);
        this.packageName = PackageName;
    }

    public JavaClassBody(String Name, String PackageName, String ParentClass, boolean Public, boolean Abstract) {
        this(Name, PackageName, Public, Abstract);
        this.parentClass = ParentClass;
    }

    public void addImport(String className) {
        this.imports.put(className, className);
    }

    public void addInterface(String interfaceName) {
        this.interfaces.add(interfaceName);
    }

    public void addConstructors(JavaMethod newConstructor) {
        this.constructors.add(newConstructor);
    }

    public void createEmptyConstructor() {
        JavaMethod constructor = new JavaMethod(this.name, SCOPE_PUBLIC, null, true);
        this.addConstructors(constructor);
    }

    public void addClassParameter(String parameterName, String parameterType, String defaultValue) {
        if (!this.variables.containsKey(parameterName)) {
            JavaMethod setterMethod = new JavaMethod("set" + TextUtil.toTitleCase((String)parameterName), SCOPE_PUBLIC, null);
            setterMethod.addParameter("\t" + parameterName.toUpperCase(), parameterType);
            setterMethod.addCodeLine("\t" + parameterName + "=" + parameterName.toUpperCase());
            JavaMethod getterMethod = new JavaMethod("get" + TextUtil.toTitleCase((String)parameterName), SCOPE_PUBLIC, parameterType);
            getterMethod.addCodeLine("\t return " + parameterName);
            JavaVariable variable = new JavaVariable(parameterName, SCOPE_PRIVATE, parameterType, defaultValue);
            this.addMethod(setterMethod);
            this.addMethod(getterMethod);
            this.addVariable(variable);
        }
    }

    public void fillInConstructors(int tabSeq) {
        if (this.constructors.size() > 0) {
            for (JavaMethod currentConstructor : this.constructors) {
                this.mainBody.append(currentConstructor.print(tabSeq));
                this.mainBody.append("\n");
            }
            this.mainBody.append("\n");
        }
    }

    private void printMethod(JavaMethod newMethod, int tabSeq) {
        this.mainBody.append(newMethod.print(tabSeq));
        this.mainBody.append("\n");
    }

    public void testRunning() {
        System.out.println("Here is the test from the java class body");
    }

    public void fillInImports() {
        if (this.imports.size() > 0) {
            Vector<String> sortingImports = new Vector<String>(this.imports.size());
            sortingImports.addAll(this.imports.values());
            Collections.sort(sortingImports);
            for (String curImport : sortingImports) {
                this.mainBody.append(KEYWORD_IMPORT);
                this.mainBody.append(" ");
                this.mainBody.append(curImport);
                this.mainBody.append(";\n");
            }
            this.mainBody.append("\n");
        }
    }

    protected void fillInInterfaces() {
        if (this.interfaces.size() > 0) {
            this.mainBody.append("implements ");
            for (String curInterface : this.interfaces) {
                this.mainBody.append(curInterface);
                this.mainBody.append(",");
            }
            this.mainBody.deleteCharAt(this.mainBody.length() - 1);
        }
    }

    protected String getObjectType() {
        return KEYWORD_CLASS;
    }

    protected String getParentClass() {
        return this.parentClass;
    }

    @Override
    public String print() {
        this.mainBody.append("package ");
        this.mainBody.append(this.packageName + ";\n\n");
        this.fillInImports();
        if (this.isPublic) {
            this.mainBody.append("public ");
        }
        if (this.isAbstract) {
            this.mainBody.append("abstract ");
        }
        this.mainBody.append(this.getObjectType() + " ");
        this.mainBody.append(this.name + " ");
        if (this.parentClass != null) {
            this.mainBody.append("extends " + this.getParentClass() + " ");
        }
        this.fillInInterfaces();
        this.mainBody.append("{\n");
        this.mainBody.append("\n");
        if (this.isCreateOnSequence()) {
            int[] allignValues = this.calculateAllignVariables(this.alignCounter);
            for (Object curObj : this.sequence) {
                if (curObj instanceof String) {
                    this.printComment((String)curObj);
                    continue;
                }
                if (curObj instanceof Variable) {
                    this.printVariable((Variable)curObj, allignValues);
                    continue;
                }
                if (!(curObj instanceof JavaMethod)) continue;
                JavaMethod jMeth = (JavaMethod)curObj;
                this.printMethod(jMeth, 1);
            }
        } else {
            this.addComments();
            this.fillInVariables();
            this.mainBody.append("\n");
            this.fillInConstructors(1);
            this.fillInMethods(1);
        }
        this.mainBody.append("}");
        return this.mainBody.toString();
    }

    private void printComment(String comment) {
        this.mainBody.append("//" + comment + "\n");
    }

    private void addComments() {
        for (String currentComment : this.commentLines) {
            this.printComment(currentComment);
        }
    }

    public JavaMethod addMainMethod() {
        JavaMethod mainMethod = new JavaMethod("main", SCOPE_PUBLIC, null);
        mainMethod.addModifier(MODIFIER_STATIC);
        mainMethod.addParameter("args", "String[]");
        this.addMethod(mainMethod);
        return mainMethod;
    }

    @Override
    public void exportFileToPath(String path) throws Exception {
        String targetPath = this.getClassFilePath(path);
        super.exportFileToPath(targetPath);
    }

    public String getClassFilePath(String path) throws Exception {
        return path + File.separator + JavaLangUtility.convertPackageToPath(this.packageName);
    }

    public String getClassFilePathWithName(String path) throws Exception {
        return path + File.separator + this.getClassFullNameAsSystemFolders();
    }

    public String getClassFullNameAsSystemFolders() throws Exception {
        return JavaLangUtility.convertPackageToPath(this.packageName) + File.separator + this.getName();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getFullPackageName() {
        return this.packageName + "." + this.getName();
    }

    public String getParentClassName() {
        return this.parentClass;
    }

    public void setParentClassName(String newParentClassName) {
        this.parentClass = newParentClassName;
    }

    public String getFullClassName() {
        return this.packageName + "." + this.getName();
    }
}

