/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.lang.script.util;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.smyld.SMYLDObject;
import org.smyld.io.FileSystem;
import org.smyld.lang.script.util.Method;
import org.smyld.lang.script.util.Variable;
import org.smyld.text.TextUtil;

public abstract class ClassBody
extends SMYLDObject {
    private static final long serialVersionUID = 1L;
    protected StringBuffer mainBody = new StringBuffer();
    protected String name;
    protected String packageName;
    protected Vector<Method> methodes = new Vector();
    protected HashMap<String, Variable> variables = new HashMap();
    protected Vector<Variable> sortVariables = new Vector();
    protected Vector<String> commentLines = new Vector();
    protected Vector<Object> sequence = new Vector();
    protected HashMap<String, String> sequenceTest = new HashMap();
    protected String extension;
    boolean createNeededFolders;
    boolean sortVariablesAlphabet = false;
    protected int alignCounter = 3;
    public static final int DEFAULT_ALLIGN_COUNTER = 3;
    boolean createOnSequence;

    public ClassBody() {
    }

    public ClassBody(String Name) {
        this.name = Name;
    }

    public Vector<Method> listMethodes() {
        return this.methodes;
    }

    public HashMap<String, Variable> listVariables() {
        return this.variables;
    }

    public void sortFieldsAlphabetically(boolean sort) {
        this.sortVariablesAlphabet = sort;
    }

    public Method getMethod(String methodName) {
        for (Method currentMethod : this.methodes) {
            if (!currentMethod.getName().equals(methodName)) continue;
            return currentMethod;
        }
        return null;
    }

    public Variable getVariable(String variableName) {
        return this.variables.get(variableName);
    }

    public void setAllignVariableCount(int newAlignCount) {
        this.alignCounter = newAlignCount;
    }

    public void addSingleCommentLine(String commentLine) {
        this.commentLines.add(commentLine);
        this.addToSequence(commentLine);
    }

    public void fillInVariables() {
        if (this.variables.size() > 0) {
            if (this.sortVariablesAlphabet) {
                Collections.sort(this.sortVariables, new Comparator<Object>(){

                    @Override
                    public int compare(Object obj1, Object obj2) {
                        Variable var1 = (Variable)obj1;
                        Variable var2 = (Variable)obj2;
                        int typeCompare = var1.getType().compareToIgnoreCase(var2.getType());
                        if (typeCompare > 0) {
                            return typeCompare;
                        }
                        if (typeCompare == 0) {
                            return var1.getName().compareToIgnoreCase(var2.getName());
                        }
                        return typeCompare;
                    }
                });
            }
            int[] allignValues = this.calculateAllignVariables(this.alignCounter);
            for (Variable currentLine : this.sortVariables) {
                this.printVariable(currentLine, allignValues);
            }
            this.mainBody.append("\n");
        }
    }

    protected void printVariable(Variable newVar, int[] allignValues) {
        this.mainBody.append("\t" + this.allignVariable(allignValues, newVar));
        this.mainBody.append("\n");
    }

    protected int[] calculateAllignVariables(int alignCount) {
        int[] longTexts = new int[alignCount];
        for (Variable currentVariable : this.variables.values()) {
            StringTokenizer tocken = new StringTokenizer(currentVariable.print());
            String currentTocken = null;
            int max = alignCount;
            if (alignCount > tocken.countTokens()) {
                max = tocken.countTokens();
            }
            for (int i = 0; i < max; ++i) {
                currentTocken = tocken.nextToken();
                if (currentTocken == null || longTexts[i] >= currentTocken.length()) continue;
                longTexts[i] = currentTocken.length();
            }
        }
        return longTexts;
    }

    private String allignVariable(int[] lengths, Variable currentVariable) {
        String currentTocken = null;
        String variableText = currentVariable.print();
        StringTokenizer tocken = new StringTokenizer(variableText);
        StringBuffer buffer = new StringBuffer();
        int max = lengths.length;
        if (lengths.length > tocken.countTokens()) {
            max = tocken.countTokens();
        }
        for (int i = 0; i < max; ++i) {
            currentTocken = tocken.nextToken();
            if (currentTocken == null) continue;
            if (lengths[i] > currentTocken.length()) {
                buffer.append(currentTocken + TextUtil.createWord((char)' ', (int)(lengths[i] - currentTocken.length() + 1)));
                continue;
            }
            buffer.append(currentTocken + " ");
        }
        if (!variableText.endsWith(currentTocken)) {
            buffer.append(variableText.substring(variableText.indexOf(currentTocken) + currentTocken.length()));
        }
        return buffer.toString();
    }

    public void fillInMethods(int tabSeq) {
        if (this.methodes.size() > 0) {
            for (Method currentMethode : this.methodes) {
                this.mainBody.append(currentMethode.print(tabSeq));
                this.mainBody.append("\n");
            }
            this.mainBody.append("\n");
        }
    }

    public void addMethod(Method newMethod) {
        this.methodes.add(newMethod);
        this.addToSequence(newMethod);
    }

    public void addMethodes(Vector<Method> newMethodes) {
        this.methodes.addAll(newMethodes);
    }

    public void addVariables(HashMap<String, Variable> newVariables) {
        this.variables.putAll(newVariables);
    }

    public void addVariable(Variable newVariable) {
        boolean exists = this.variables.containsKey(newVariable.getName());
        this.variables.put(newVariable.getName(), newVariable);
        this.addToSequence(newVariable);
        if (!exists) {
            this.sortVariables.add(newVariable);
        }
    }

    public String print() {
        return null;
    }

    private void addToSequence(Object incObject) {
        if (incObject instanceof Variable) {
            String variableName = ((Variable)incObject).getName();
            if (!this.sequenceTest.containsKey(variableName)) {
                this.sequenceTest.put(variableName, variableName);
                this.sequence.add(incObject);
            }
        } else {
            this.sequence.add(incObject);
        }
    }

    public void exportFileToPath(String path) throws Exception {
        if (FileSystem.confirmFoldersExistence((String)path)) {
            FileOutputStream fout = new FileOutputStream(path + File.separator + this.name + "." + this.extension);
            fout.write(this.print().getBytes());
            fout.flush();
            fout.close();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isCreateNeededFolders() {
        return this.createNeededFolders;
    }

    public void setCreateNeededFolders(boolean createNeededFolders) {
        this.createNeededFolders = createNeededFolders;
    }

    public boolean isCreateOnSequence() {
        return this.createOnSequence;
    }

    public void setCreateOnSequence(boolean createOnSequence) {
        this.createOnSequence = createOnSequence;
    }
}

