/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.lang.script.converter;

import java.io.File;
import java.io.IOException;
import org.smyld.SMYLDObject;
import org.smyld.lang.script.util.CodeReader;
import org.smyld.lang.script.util.CodeWriter;
import org.smyld.lang.script.util.Scriptlet;

public abstract class Converter
extends SMYLDObject {
    Scriptlet sourceScriptlet;
    Scriptlet destinationScriptlet;
    CodeReader currentCodeReader;
    CodeWriter currentCodeWriter;

    public void loadCodeFile(String fileName) throws IOException {
        this.currentCodeReader = new CodeReader(new File(fileName), this.getSourceLangDelimiter());
    }

    public void loadCodeText(String codeText) throws IOException {
        this.currentCodeReader = new CodeReader(codeText, this.getSourceLangDelimiter());
    }

    public void startConversion() {
        try {
            String currentLine = null;
            while ((currentLine = this.currentCodeReader.getNextCodeLine()) != null) {
                this.doConvert(currentLine.trim().toLowerCase());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public abstract void doConvert(String var1);

    public abstract String getSourceLangDelimiter();
}

