/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.lang.script.util;

import java.util.HashMap;
import org.smyld.SMYLDObject;
import org.smyld.lang.script.util.LangsConstants;

public class Variable
extends SMYLDObject
implements LangsConstants {
    private static final long serialVersionUID = 3213958873985871452L;
    protected String name;
    protected String type;
    protected String scope;
    protected String DefaultValue;
    protected HashMap<String, String> modifiers = new HashMap();
    protected StringBuffer body = new StringBuffer();
    public static final String SCOPE_PUBLIC = "public";
    public static final String SCOPE_PRIVATE = "private";
    int srcLang;

    public Variable() {
    }

    public Variable(String Name) {
        this.name = Name;
    }

    public Variable(int langSrc) {
        this.srcLang = langSrc;
    }

    public Variable(String Name, int langSrc) {
        this.name = Name;
        this.srcLang = langSrc;
    }

    public Variable(String Name, String Scope) {
        this(Name);
        this.scope = Scope;
    }

    public Variable(String Name, String Scope, String Type) {
        this(Name, Scope);
        this.type = Type;
    }

    public Variable(String Name, String Scope, String Type, String defaultValue) {
        this(Name, Scope, Type);
        this.DefaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void addModifier(String newModifier) {
        this.modifiers.put(newModifier, newModifier);
    }

    public void fillInModifiers() {
        if (this.modifiers.size() > 0) {
            for (String curMod : this.modifiers.values()) {
                this.body.append(curMod);
                this.body.append(" ");
            }
        }
    }

    public void importVariable(Variable srcVariable) {
        this.name = srcVariable.getName();
        this.modifiers = srcVariable.modifiers;
        this.scope = srcVariable.scope;
        this.DefaultValue = srcVariable.DefaultValue;
        this.type = srcVariable.type;
    }

    public String print() {
        this.body.setLength(0);
        this.body.append(this.scope);
        this.body.append(" ");
        this.fillInModifiers();
        this.body.append(this.type);
        this.body.append(" ");
        this.body.append(this.name);
        return this.body.toString();
    }

    public String getDefaultValue() {
        return this.DefaultValue;
    }

    public void setDefaultValue(String newDefaultValue) {
        this.DefaultValue = newDefaultValue;
    }

    public int getSrcLang() {
        return this.srcLang;
    }

    public void setSrcLang(int srcLang) {
        this.srcLang = srcLang;
    }

    public HashMap<String, String> getModifiers() {
        return this.modifiers;
    }
}

