/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.lang.script.vb;

import org.smyld.lang.script.util.Method;
import org.smyld.lang.script.vb.VBConstants;
import org.smyld.lang.script.vb.VBVariable;

public class VBMethod
extends Method
implements VBConstants {
    private static final long serialVersionUID = 1L;
    boolean isFunction = true;

    public VBMethod(String Name, String Scope, String ReturnType) {
        super(Name, Scope, ReturnType);
    }

    public VBMethod() {
    }

    @Override
    public boolean parseMethod(String codeLine) {
        int returnTypeIndex;
        String[] elements = this.exctractDefinitionPart(codeLine = codeLine.trim());
        if (this.isScopWord(elements[0])) {
            this.scope = elements[0];
            this.detectFunction(elements[1]);
            this.name = elements[2];
        } else {
            this.detectFunction(elements[0]);
            this.name = elements[1];
        }
        String[] parameters = this.exctractParameters(codeLine);
        if (parameters != null) {
            this.parseParameters(parameters);
        }
        if ((returnTypeIndex = codeLine.lastIndexOf("as")) != -1) {
            this.returnType = codeLine.substring(returnTypeIndex + "as".length());
        }
        return true;
    }

    private void parseParameters(String[] params) {
        VBVariable vbVariable = new VBVariable();
        for (String element : params) {
            vbVariable.parseVariable(element);
            this.addParameter(vbVariable.getName(), vbVariable.getType());
        }
    }

    private boolean isScopWord(String word) {
        return word.equals("public") || word.equals("private");
    }

    private void detectFunction(String word) {
        if (word.equals("sub")) {
            this.isFunction = false;
        } else if (word.equals("function")) {
            this.isFunction = true;
        }
    }

    @Override
    public String fillParameter(String name, String type) {
        return VBVariable.constructVariable(name, type);
    }

    @Override
    public String print() {
        if (this.scope != null) {
            this.body.append(this.scope + " ");
        }
        this.fillInModifiers();
        if (this.returnType == null) {
            this.isFunction = false;
        }
        if (this.isFunction) {
            this.body.append("Function ");
        } else {
            this.body.append("Sub ");
        }
        this.body.append(this.name);
        this.body.append("(");
        this.fillInParameters();
        this.body.append(") ");
        if (this.isFunction) {
            this.body.append("As ");
            this.body.append(this.returnType);
        }
        this.body.append("\n");
        if (this.isFunction) {
            this.body.append("End Function");
        } else {
            this.body.append("End Sub");
        }
        return this.body.toString();
    }
}

