/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.lang.script.vb;

import java.util.HashMap;
import org.smyld.lang.script.util.BooleanExpression;
import org.smyld.lang.script.util.Scriptlet;
import org.smyld.lang.script.vb.VBBooleanExp;
import org.smyld.lang.script.vb.VBConstants;
import org.smyld.lang.script.vb.VBMethod;

public class VBScriptlet
extends Scriptlet
implements VBConstants {
    private static final long serialVersionUID = 1L;

    public VBScriptlet() {
        this.init();
    }

    private void init() {
        this.scriptBooleanExp = new VBBooleanExp();
    }

    @Override
    public int getCodeLineType(String codeLine) {
        if ((codeLine = codeLine.trim().toLowerCase()).startsWith("dim")) {
            return 1;
        }
        if (codeLine.startsWith("sub")) {
            return 4;
        }
        if (codeLine.startsWith("end sub")) {
            return 5;
        }
        if (codeLine.startsWith("function")) {
            return 2;
        }
        if (codeLine.startsWith("end function")) {
            return 3;
        }
        if (codeLine.startsWith("if")) {
            return 6;
        }
        if (codeLine.startsWith("else")) {
            return 7;
        }
        if (codeLine.startsWith("end if")) {
            return 8;
        }
        if (codeLine.startsWith("'")) {
            return 11;
        }
        if (codeLine.startsWith("call")) {
            return 17;
        }
        if (codeLine.startsWith("declare")) {
            return 1;
        }
        if (codeLine.startsWith("public const")) {
            return 18;
        }
        if (codeLine.startsWith("do")) {
            return 19;
        }
        if (codeLine.startsWith("loop")) {
            return 20;
        }
        if (codeLine.startsWith("for")) {
            return 9;
        }
        if (codeLine.startsWith("next")) {
            return 10;
        }
        if (codeLine.startsWith("exit do")) {
            return 23;
        }
        if (codeLine.startsWith("exit for")) {
            return 22;
        }
        if (codeLine.startsWith("exit function")) {
            return 24;
        }
        if (codeLine.startsWith("exit sub")) {
            return 21;
        }
        if (codeLine.startsWith("goto")) {
            return 25;
        }
        if (codeLine.startsWith("on error")) {
            return 26;
        }
        if (codeLine.startsWith("option explicit")) {
            return 27;
        }
        if (codeLine.startsWith("resume")) {
            return 28;
        }
        if (codeLine.startsWith("end")) {
            return 16;
        }
        if (codeLine.startsWith("private")) {
            return 30;
        }
        if (codeLine.startsWith("select case")) {
            return 31;
        }
        if (codeLine.startsWith("end select")) {
            return 33;
        }
        if (codeLine.startsWith("case")) {
            return 32;
        }
        if (codeLine.startsWith("const")) {
            return 18;
        }
        if (this.isLable(codeLine)) {
            return 29;
        }
        if (!this.isEquation(codeLine)) {
            return -1;
        }
        return 0;
    }

    private boolean isLable(String codeLine) {
        int spaceIndex = codeLine.indexOf(" ");
        int dotIndex = codeLine.indexOf(":");
        if (dotIndex != -1) {
            if (spaceIndex != -1) {
                if (spaceIndex > dotIndex) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean isEquation(String codeLine) {
        int equalIndex = codeLine.indexOf("=");
        return equalIndex != -1;
    }

    @Override
    public String doFilterComment(String codeLine) {
        int pos = 0;
        pos = codeLine.indexOf(this.getCodeComment());
        if (pos != -1) {
            return codeLine.substring(0, pos);
        }
        return codeLine;
    }

    public BooleanExpression doParseIfStatement(String ifCodeLine) {
        if (this.containsQutations(ifCodeLine)) {
            HashMap<String, String> result = this.filterOutQutations(ifCodeLine);
            ifCodeLine = result.get("fileteredCode");
        }
        ifCodeLine = this.doFilterComment(ifCodeLine);
        String ifCondition = ifCodeLine.substring(ifCodeLine.indexOf("if") + "if".length(), ifCodeLine.indexOf("then"));
        this.scriptBooleanExp.setText(ifCondition);
        this.scriptBooleanExp.parseText();
        return this.scriptBooleanExp;
    }

    public HashMap<String, String> filterOutQutations(String codeLine) {
        boolean insideQute = false;
        HashMap<String, String> qutations = new HashMap<String, String>();
        StringBuffer filteredCode = new StringBuffer();
        int endPos = 0;
        int startPos = 0;
        int qutationsCount = 0;
        for (int i = 0; i < codeLine.length(); ++i) {
            char currentChar = codeLine.charAt(i);
            if (currentChar == '\"') {
                if (!insideQute) {
                    insideQute = true;
                    startPos = i + 1;
                    continue;
                }
                insideQute = false;
                endPos = i;
                String quteID = "q~" + qutationsCount;
                qutations.put(quteID, codeLine.substring(startPos, endPos));
                filteredCode.append(quteID);
                ++qutationsCount;
                continue;
            }
            if (insideQute) continue;
            filteredCode.append(currentChar);
        }
        qutations.put("fileteredCode", filteredCode.toString());
        return qutations;
    }

    public VBMethod doParseFunction(String funCodeLine) {
        funCodeLine = this.doFilterComment(funCodeLine);
        VBMethod newMethod = new VBMethod();
        return newMethod;
    }

    @Override
    public String getCodeComment() {
        return "'";
    }
}

