/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.engine;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.CRC32;

public class Packet {
    public static final int MAX_SIZE = 1024;
    public static final int HEADER_SIZE = 4;
    public static final int CHECKSUM_SIZE = 8;
    public static final int MIN_SIZE = 12;
    public static final int MAX_DATA = 1012;
    private static byte[] byteArray = new byte[1024];
    private static ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray);
    private static final byte[] CLOSE_DATA = "Bye!".getBytes();

    public static int calculateMaxData(int remaining) {
        return remaining - 12;
    }

    public static boolean isClose(byte[] data) {
        return Arrays.equals(CLOSE_DATA, data);
    }

    public static byte[] getCloseData() {
        return CLOSE_DATA;
    }

    public static byte[] getBytes(ByteBuffer[] srcs, int maxSize) {
        ByteBuffer buffer = ByteBuffer.allocate(maxSize);
        for (ByteBuffer src : srcs) {
            if (src.remaining() <= buffer.remaining()) {
                buffer.put(src);
                continue;
            }
            ByteBuffer srcDup = src.duplicate();
            srcDup.limit(src.position() + buffer.remaining());
            buffer.put(srcDup);
            src.position(srcDup.position());
        }
        buffer.flip();
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public static ByteBuffer encode(int offset, ByteBuffer[] data, int maxDataSize) {
        byte[] bytes = Packet.getBytes(data, maxDataSize);
        if (bytes.length > 0) {
            return Packet.encode(offset, bytes);
        }
        return null;
    }

    public static ByteBuffer encode(int offset, byte[] data) {
        CRC32 crc = new CRC32();
        byteBuffer.clear();
        byteBuffer.putInt(data.length + 12);
        byteBuffer.put(data);
        crc.update(byteArray, 0, byteBuffer.position());
        byteBuffer.putLong(crc.getValue());
        byteBuffer.flip();
        int size = byteBuffer.limit();
        int i = 0;
        while (i < size) {
            int n = i++;
            byteArray[n] = (byte)(byteArray[n] + offset);
        }
        return byteBuffer;
    }

    public static int decodeSize(int offset, ByteBuffer data) {
        if (data.remaining() < 12) {
            return -1;
        }
        byteBuffer.clear();
        byteBuffer.putInt(data.duplicate().getInt());
        int i = 0;
        while (i < 4) {
            int n = i++;
            byteArray[n] = (byte)(byteArray[n] - offset);
        }
        byteBuffer.flip();
        int size = byteBuffer.getInt();
        if (size > 1024) {
            throw new IllegalArgumentException();
        }
        if (size > data.remaining()) {
            return -1;
        }
        return size;
    }

    public static byte[] decode(int offset, ByteBuffer data, int size) {
        ByteBuffer dataDuplicate = data.duplicate();
        dataDuplicate.limit(dataDuplicate.position() + size);
        byteBuffer.clear();
        byteBuffer.put(dataDuplicate);
        byteBuffer.flip();
        data.position(dataDuplicate.position());
        int i = 0;
        while (i < size) {
            int n = i++;
            byteArray[n] = (byte)(byteArray[n] - offset);
        }
        CRC32 crc = new CRC32();
        crc.update(byteArray, 0, size - 8);
        if (crc.getValue() != byteBuffer.getLong(size - 8)) {
            throw new IllegalArgumentException();
        }
        byte[] decoded = new byte[size - 12];
        System.arraycopy(byteArray, 4, decoded, 0, decoded.length);
        return decoded;
    }
}

