/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.snf4j.core.EndingAction;
import org.snf4j.core.handler.SessionEvent;
import org.snf4j.core.session.ssl.SSLEngineBuilder;
import org.snf4j.core.timer.ITimerTask;
import org.snf4j.example.file.AbstractFileHandler;
import org.snf4j.example.file.FileClient;
import org.snf4j.example.file.Logger;

public class FileClientHandler
extends AbstractFileHandler {
    private final Object PROGRESS_UPDATE_EVENT = new Object();
    private final String path;
    ITimerTask progressTimer;

    FileClientHandler(SSLEngineBuilder builder, String path) {
        super(builder);
        this.config.setEndingAction(EndingAction.STOP).setMinInBufferCapacity(FileClient.BUFFER_SIZE).setMinOutBufferCapacity(FileClient.BUFFER_SIZE);
        this.path = path;
    }

    public void read(Object msg) {
        try {
            if (FileClient.DISCARD) {
                this.fileLength += (long)((ByteBuffer)msg).remaining();
            } else if (this.fileChannel != null) {
                this.fileLength += (long)this.fileChannel.write((ByteBuffer)msg);
            }
        }
        catch (IOException e) {
            Logger.error(e.toString());
            this.getSession().close();
        }
        finally {
            this.getSession().release((ByteBuffer)msg);
        }
    }

    public void timer(Object event) {
        long time = System.currentTimeMillis() - this.startTime;
        Logger.info(String.format("Download progress: %,d bytes (%,d bytes/sec)", this.fileLength, this.fileLength * 1000L / time));
    }

    @Override
    public void event(SessionEvent event) {
        switch (event) {
            case READY: {
                try {
                    File filePath = new File(FileClient.DOWNLOAD_DIR + File.separator + new File(this.path).getName());
                    if (filePath.exists()) {
                        if (FileClient.DELETE_IF_EXISTS) {
                            filePath.delete();
                        } else {
                            Logger.error("File " + filePath.getAbsolutePath() + " already exists");
                            this.getSession().close();
                            return;
                        }
                    }
                    if (!FileClient.DISCARD) {
                        this.file = new RandomAccessFile(filePath, "rw");
                        this.fileChannel = this.file.getChannel();
                    }
                    this.progressTimer = this.getSession().getTimer().scheduleEvent(this.PROGRESS_UPDATE_EVENT, 15000L, 15000L);
                    Logger.info("Downloading " + filePath.getAbsolutePath());
                    this.startTime = System.currentTimeMillis();
                }
                catch (Exception e) {
                    Logger.error(e.toString());
                    this.getSession().close();
                    return;
                }
                ByteBuffer buf = this.getSession().allocate(4096);
                buf.put(this.path.getBytes(StandardCharsets.UTF_8));
                buf.put((byte)0);
                buf.flip();
                this.getSession().writenf(buf);
                break;
            }
            case CLOSED: {
                if (this.file == null && !FileClient.DISCARD) break;
                long time = System.currentTimeMillis() - this.startTime;
                if (this.progressTimer != null) {
                    this.progressTimer.cancelTask();
                }
                Logger.info(String.format("Downloading of %,d bytes completed in %,d msec (%,d bytes/sec)", this.fileLength, time, this.fileLength * 1000L / time));
                break;
            }
        }
        super.event(event);
    }

    public void exception(Throwable t) {
        Logger.error(t.toString());
    }
}

