/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.file;

import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.KeyManagerFactory;
import org.snf4j.core.SelectorLoop;
import org.snf4j.core.factory.AbstractSessionFactory;
import org.snf4j.core.factory.IStreamSessionFactory;
import org.snf4j.core.handler.IStreamHandler;
import org.snf4j.core.pool.DefaultSelectorLoopPool;
import org.snf4j.core.pool.ISelectorLoopPool;
import org.snf4j.core.session.ssl.ClientAuth;
import org.snf4j.core.session.ssl.SSLContextBuilder;
import org.snf4j.core.session.ssl.SSLEngineBuilder;
import org.snf4j.example.file.FileServerHandler;
import org.snf4j.example.file.KeyStoreLoader;

public class FileServer {
    static final String PREFIX = "org.snf4j.";
    static final int PORT = Integer.getInteger("org.snf4j.Port", 8001);
    static final int POOL_SIZE = Integer.getInteger("org.snf4j.PoolSize", 8);
    static final boolean SECURE = System.getProperty("org.snf4j.Secure") != null;
    static final int BUFFER_SIZE = Integer.getInteger("org.snf4j.BufferSize", 4096);
    static final int BUFFER_COUNT = Integer.getInteger("org.snf4j.BufferCount", 16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SelectorLoop loop = new SelectorLoop();
        DefaultSelectorLoopPool pool = null;
        try {
            loop.start();
            if (POOL_SIZE > 0) {
                pool = new DefaultSelectorLoopPool(POOL_SIZE);
                loop.setPool((ISelectorLoopPool)pool);
            }
            ServerSocketChannel channel = ServerSocketChannel.open();
            channel.configureBlocking(false);
            channel.socket().bind(new InetSocketAddress(PORT));
            final SSLEngineBuilder builder = !SECURE ? null : SSLContextBuilder.forServer((KeyManagerFactory)KeyStoreLoader.keyManagerFactory()).trustManager(KeyStoreLoader.trustManagerFactory()).clientAuth(ClientAuth.REQUIRED).engineBuilder();
            loop.register(channel, (IStreamSessionFactory)new AbstractSessionFactory(SECURE){

                protected IStreamHandler createHandler(SocketChannel channel) {
                    return new FileServerHandler(builder);
                }
            });
            loop.join();
        }
        finally {
            loop.stop();
            if (pool != null) {
                pool.stop();
            }
        }
    }
}

