/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.heartbeat;

import java.net.SocketAddress;
import org.snf4j.core.EndingAction;
import org.snf4j.core.factory.DefaultSessionStructureFactory;
import org.snf4j.core.factory.ISessionStructureFactory;
import org.snf4j.core.handler.AbstractDatagramHandler;
import org.snf4j.core.handler.SessionEvent;
import org.snf4j.core.session.ISessionConfig;
import org.snf4j.core.timer.ITimer;
import org.snf4j.core.timer.ITimerTask;
import org.snf4j.example.heartbeat.Packet;
import org.snf4j.example.heartbeat.SessionConfig;

public class HeartbeatHandler
extends AbstractDatagramHandler {
    private ITimerTask beatTimer;
    private ITimerTask downTimer;
    private final ITimer timer;
    private State state;
    private final long beatPeriod;
    private final long downPeriod;
    private final SocketAddress remoteAddress;

    public HeartbeatHandler(ITimer timer, long beatPeriod, long downPeriod) {
        this(null, timer, beatPeriod, downPeriod);
    }

    public HeartbeatHandler(SocketAddress remoteAddress, ITimer timer, long beatPeriod, long downPeriod) {
        this.timer = timer;
        this.beatPeriod = beatPeriod;
        this.downPeriod = downPeriod;
        this.remoteAddress = remoteAddress;
    }

    public void read(byte[] data) {
    }

    public void read(SocketAddress remoteAddress, byte[] datagram) {
    }

    public void read(Object msg) {
        this.up();
    }

    public void read(SocketAddress remoteAddress, Object msg) {
        if (remoteAddress.equals(this.remoteAddress)) {
            this.up();
        }
    }

    public void event(SessionEvent event) {
        switch (event) {
            case OPENED: {
                this.up();
                break;
            }
            case READY: {
                this.beatTimer = this.getSession().getTimer().scheduleTask(new Runnable(){

                    @Override
                    public void run() {
                        HeartbeatHandler.this.beat();
                    }
                }, 0L, this.beatPeriod, true);
                break;
            }
            case CLOSED: {
                if (this.beatTimer != null) {
                    this.beatTimer.cancelTask();
                }
                if (this.downTimer == null) break;
                this.downTimer.cancelTask();
            }
        }
    }

    public void timer(Runnable task) {
        task.run();
    }

    public ISessionConfig getConfig() {
        return new SessionConfig().setEndingAction(EndingAction.STOP);
    }

    public ISessionStructureFactory getFactory() {
        return new DefaultSessionStructureFactory(){

            public ITimer getTimer() {
                return HeartbeatHandler.this.timer;
            }
        };
    }

    private void beat() {
        if (this.remoteAddress != null) {
            this.getSession().send(this.remoteAddress, (Object)Packet.INSTANCE);
        } else {
            this.getSession().write((Object)Packet.INSTANCE);
        }
    }

    private void up() {
        if (this.downTimer != null) {
            this.downTimer.cancelTask();
            this.update(this.state, State.UP);
        } else if (this.remoteAddress != null) {
            this.update(this.state, State.UNKNOWN);
        }
        this.downTimer = this.getSession().getTimer().scheduleTask(new Runnable(){

            @Override
            public void run() {
                HeartbeatHandler.this.down();
            }
        }, this.downPeriod, true);
    }

    private void down() {
        if (this.getSession().getParent() != null) {
            this.getSession().close();
        }
        this.update(this.state, State.DOWN);
    }

    private void update(State oldState, State newState) {
        if (oldState != newState) {
            SocketAddress address = this.remoteAddress == null ? this.getSession().getRemoteAddress() : this.remoteAddress;
            System.out.println("[" + address + "] " + (Object)((Object)newState));
            this.state = newState;
        }
    }

    static enum State {
        UNKNOWN,
        UP,
        DOWN;

    }
}

