/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.websocket;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.snf4j.core.SSLSession;
import org.snf4j.core.codec.IBaseDecoder;
import org.snf4j.core.codec.IDecoder;
import org.snf4j.core.session.ISession;
import org.snf4j.core.session.IStreamSession;
import org.snf4j.example.websocket.PageContent;

public class IndexPageDecoder
implements IDecoder<byte[], byte[]>,
IBaseDecoder<byte[], byte[]> {
    static final byte CR = 13;
    static final byte LF = 10;
    static final byte[] CRLF = new byte[]{13, 10};
    static final byte[] CRLF2 = new byte[]{13, 10, 13, 10};
    static final String GET = "GET";
    static final String HTTP_VERSION = "HTTP/1.1";
    static final String OK = "200 OK";
    static final String BAD_REQUEST = "400 Bad Request";
    static final String FORBIDDEN = "403 Forbidden";
    static final String NOT_FOUND = "404 Not Found";
    static final String CONTENT_TYPE = "Content-Type: text/html; charset=UTF-8";
    static final String INDEX_PAGE_DECODER = "index-page-decoder";
    static final String[] INDEX_PAGE_ENDPOINTS = new String[]{"/", "/index.htm", "/index.html"};
    static final String[] WEBSOCKET_ENDPOINTS = new String[]{"/chat", "/echo"};
    private final String host;

    static boolean matches(String value, String[] expectedValues) {
        for (String ev : expectedValues) {
            if (!ev.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public IndexPageDecoder(String host) {
        this.host = host;
    }

    public Class<byte[]> getInboundType() {
        return byte[].class;
    }

    public Class<byte[]> getOutboundType() {
        return byte[].class;
    }

    public int available(ISession session, ByteBuffer buffer, boolean flipped) {
        ByteBuffer duplicate = buffer.duplicate();
        if (!flipped) {
            duplicate.flip();
        }
        byte[] data = new byte[duplicate.remaining()];
        duplicate.get(data);
        return this.available(session, data, 0, data.length);
    }

    public int available(ISession session, byte[] buffer, int off, int len) {
        if (len < CRLF2.length) {
            return 0;
        }
        for (int i = off; i < off + len - 3; ++i) {
            boolean found = true;
            for (int j = 0; j < 4; ++j) {
                if (buffer[i + j] == CRLF2[j]) continue;
                found = false;
            }
            if (!found) continue;
            return i + 4;
        }
        return 0;
    }

    void response(ISession session, String status, String[] fields, String content) {
        StringBuilder response = new StringBuilder();
        response.append(HTTP_VERSION);
        response.append(" ");
        response.append(status);
        response.append(new String(CRLF));
        if (fields != null && fields.length > 0) {
            for (String field : fields) {
                response.append(field);
                response.append(new String(CRLF));
            }
        }
        response.append(new String(CRLF));
        if (content != null && !content.isEmpty()) {
            response.append(content);
        }
        ((IStreamSession)session).writenf(response.toString().getBytes(StandardCharsets.US_ASCII));
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(ISession session, byte[] data, List<byte[]> out) throws Exception {
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data)));
        try {
            String[] items;
            String line = in.readLine();
            if (line != null && (items = line.split(" ")).length > 2 && HTTP_VERSION.equals(items[2])) {
                if (GET.equalsIgnoreCase(items[0])) {
                    if (IndexPageDecoder.matches(items[1], INDEX_PAGE_ENDPOINTS)) {
                        String protocol = session instanceof SSLSession ? "wss://" : "ws://";
                        this.response(session, OK, new String[]{CONTENT_TYPE}, PageContent.get(protocol + this.host + "/chat"));
                    } else if (IndexPageDecoder.matches(items[1], WEBSOCKET_ENDPOINTS)) {
                        session.getCodecPipeline().remove((Object)INDEX_PAGE_DECODER);
                        out.add(data);
                    } else {
                        this.response(session, NOT_FOUND, null, null);
                    }
                    return;
                }
                this.response(session, FORBIDDEN, null, null);
            }
            this.response(session, BAD_REQUEST, null, null);
        }
        finally {
            in.close();
        }
    }
}

