/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.websocket;

import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.snf4j.core.SelectorLoop;
import org.snf4j.core.factory.IStreamSessionFactory;
import org.snf4j.example.websocket.WebSocketServerHandler;
import org.snf4j.websocket.AbstractWebSocketSessionFactory;
import org.snf4j.websocket.IWebSocketHandler;

public class WebSocketServer {
    static final String PREFIX = "org.snf4j.";
    static final boolean SECURE = Integer.getInteger("org.snf4j.Secure") != null;
    static final int PORT = Integer.getInteger("org.snf4j.Port", SECURE ? 8443 : 8080);
    static final boolean COMPRESS = System.getProperty("org.snf4j.Compress") != null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SelectorLoop loop = new SelectorLoop();
        final String host = "127.0.0.1:" + PORT;
        String endpoint = (SECURE ? "https" : "http") + "://" + host + '/';
        try {
            loop.start();
            ServerSocketChannel channel = ServerSocketChannel.open();
            channel.configureBlocking(false);
            channel.socket().bind(new InetSocketAddress(PORT));
            loop.register(channel, (IStreamSessionFactory)new AbstractWebSocketSessionFactory(SECURE){

                protected IWebSocketHandler createHandler(SocketChannel channel) {
                    return new WebSocketServerHandler(host, COMPRESS);
                }
            }).sync();
            WebSocketServer.info("Server is ready");
            WebSocketServer.info("To enter Web Socket Chat open a web browser and navigate to " + endpoint);
            loop.join();
        }
        finally {
            loop.stop();
        }
    }

    static void info(String msg) {
        System.out.println("[INFO] " + msg);
    }
}

