/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.dtls;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.snf4j.core.codec.DefaultCodecExecutor;
import org.snf4j.core.codec.ICodecExecutor;
import org.snf4j.core.codec.IDecoder;
import org.snf4j.core.codec.IEncoder;
import org.snf4j.core.session.DefaultSessionConfig;
import org.snf4j.core.session.SSLEngineCreateException;
import org.snf4j.example.dtls.PacketDecoder;
import org.snf4j.example.dtls.PacketEncoder;

public class SessionConfig
extends DefaultSessionConfig {
    static final int MAX_PACKET_SIZE = 1024;
    static final int MAX_APPLICATION_DATA_SIZE = 512;
    static volatile SSLContext sslContext = null;

    SessionConfig() {
        this.setMinInBufferCapacity(1024);
        this.setMinOutBufferCapacity(1024);
        this.setIgnorePossiblyIncompleteDatagrams(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(KeyStore ks, String fileName, char[] password) throws Exception {
        try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);){
            ks.load(in, password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSLContext getSSLContext() throws SSLEngineCreateException {
        if (sslContext == null) {
            try {
                Class<SessionConfig> clazz = SessionConfig.class;
                synchronized (SessionConfig.class) {
                    if (sslContext == null) {
                        KeyStore ks = KeyStore.getInstance("JKS");
                        KeyStore ts = KeyStore.getInstance("JKS");
                        char[] password = "password".toCharArray();
                        this.load(ks, "/keystore.jks", password);
                        this.load(ts, "/keystore.jks", password);
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                        kmf.init(ks, password);
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                        tmf.init(ts);
                        SSLContext ctx = SSLContext.getInstance("DTLS");
                        ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                        sslContext = ctx;
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                throw new SSLEngineCreateException((Throwable)e);
            }
        }
        {
            return sslContext;
        }
    }

    public SSLEngine createSSLEngine(boolean clientMode) throws SSLEngineCreateException {
        SSLEngine engine = this.getSSLContext().createSSLEngine();
        engine.setUseClientMode(clientMode);
        if (!clientMode) {
            engine.setNeedClientAuth(true);
        }
        SSLParameters params = engine.getSSLParameters();
        try {
            Method method = SSLParameters.class.getMethod("setMaximumPacketSize", Integer.TYPE);
            method.invoke((Object)params, 1024);
            engine.setSSLParameters(params);
        }
        catch (Exception e) {
            throw new SSLEngineCreateException((Throwable)e);
        }
        return engine;
    }

    public ICodecExecutor createCodecExecutor() {
        DefaultCodecExecutor executor = new DefaultCodecExecutor();
        executor.getPipeline().add((Object)"DECODER", (IDecoder)new PacketDecoder());
        executor.getPipeline().add((Object)"ENCODER", (IEncoder)new PacketEncoder());
        return executor;
    }
}

