/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.earlydata;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import org.snf4j.core.codec.ICodecExecutor;
import org.snf4j.core.handler.SessionEvent;
import org.snf4j.core.session.ISession;
import org.snf4j.core.session.IStreamSession;
import org.snf4j.example.earlydata.EarlyDataHandler;
import org.snf4j.example.earlydata.Logger;
import org.snf4j.example.earlydata.SessionConfig;
import org.snf4j.tls.engine.IEarlyDataHandler;

public class EarlyDataClientHandler
extends EarlyDataHandler
implements IEarlyDataHandler {
    private final String cmd;
    private Queue<byte[]> earlyData;
    private boolean earlyDataAccepted;

    public EarlyDataClientHandler(String cmd) {
        this.cmd = cmd;
    }

    @Override
    public void event(SessionEvent event) {
        super.event(event);
        if (!this.earlyDataAccepted) {
            switch (event) {
                case READY: {
                    this.getSession().writenf((Object)this.cmd);
                }
            }
        }
    }

    public void read(Object msg) {
        Logger.inf("response: " + msg);
    }

    public boolean hasEarlyData() {
        return true;
    }

    public byte[] nextEarlyData(String protocol) {
        if (this.earlyData == null) {
            this.earlyData = new LinkedList<byte[]>();
            try {
                IStreamSession session = this.getSession();
                ICodecExecutor executor = SessionConfig.createCodecExecutor(protocol, true);
                executor.syncEncoders((ISession)session);
                for (Object data : executor.encode((ISession)session, (Object)this.cmd)) {
                    ByteBuffer buffer = (ByteBuffer)data;
                    byte[] bytes = new byte[buffer.remaining()];
                    buffer.get(bytes);
                    this.getSession().release(buffer);
                    this.earlyData.add(bytes);
                }
            }
            catch (Exception e) {
                Logger.err(e.getMessage());
            }
        }
        return this.earlyData.poll();
    }

    public void acceptedEarlyData() {
        Logger.inf("early data accepted");
        this.earlyDataAccepted = true;
    }

    public void rejectedEarlyData() {
        Logger.inf("early data rejected");
    }
}

