/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.earlydata;

import org.snf4j.core.allocator.IByteBufferAllocator;
import org.snf4j.core.allocator.ThreadLocalCachingAllocator;
import org.snf4j.core.factory.DefaultSessionStructureFactory;
import org.snf4j.core.factory.ISessionStructureFactory;
import org.snf4j.core.handler.AbstractStreamHandler;
import org.snf4j.core.handler.SessionEvent;
import org.snf4j.core.handler.SessionIncident;
import org.snf4j.core.session.DefaultSessionConfig;
import org.snf4j.core.session.ISessionConfig;
import org.snf4j.example.earlydata.SessionConfig;
import org.snf4j.example.echo.Logger;
import org.snf4j.tls.alert.Alert;
import org.snf4j.tls.engine.IApplicationProtocolHandler;

public abstract class EarlyDataHandler
extends AbstractStreamHandler
implements IApplicationProtocolHandler {
    private static final IByteBufferAllocator ALLOCATOR = new ThreadLocalCachingAllocator(true);
    protected DefaultSessionConfig config = new SessionConfig().setOptimizeDataCopying(true).setWaitForInboundCloseMessage(true);

    public String selectApplicationProtocol(String[] offeredProtocols, String[] supportedProtocols) throws Alert {
        return null;
    }

    public void selectedApplicationProtocol(String protocol) throws Alert {
        Logger.inf("protocol: " + protocol);
        SessionConfig.updateCodecPipeline(this.getSession().getCodecPipeline(), protocol);
    }

    public void event(SessionEvent event) {
        Logger.inf("session " + event.toString().toLowerCase());
    }

    public void exception(Throwable e) {
        Logger.err(e.toString());
    }

    public boolean incident(SessionIncident incident, Throwable t) {
        Logger.err(incident + ": " + t.toString());
        return true;
    }

    public ISessionConfig getConfig() {
        return this.config;
    }

    public ISessionStructureFactory getFactory() {
        return new DefaultSessionStructureFactory(){

            public IByteBufferAllocator getAllocator() {
                return ALLOCATOR;
            }
        };
    }
}

