/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.earlydata;

import org.snf4j.core.codec.DefaultCodecExecutor;
import org.snf4j.core.codec.ICodecExecutor;
import org.snf4j.core.codec.ICodecPipeline;
import org.snf4j.core.codec.IDecoder;
import org.snf4j.core.codec.IEncoder;
import org.snf4j.core.session.DefaultSessionConfig;
import org.snf4j.example.earlydata.Decoder;
import org.snf4j.example.earlydata.Encoder;

public class SessionConfig
extends DefaultSessionConfig {
    public static final String DECODER = "DECODER";
    public static final String ENCODER = "ENCODER";

    public ICodecExecutor createCodecExecutor() {
        return SessionConfig.createCodecExecutor(0, false);
    }

    static int shift(String protocol) {
        return Integer.parseInt(protocol.substring(1));
    }

    static ICodecExecutor createCodecExecutor(String protocol, boolean onlyEncoders) {
        return SessionConfig.createCodecExecutor(SessionConfig.shift(protocol), onlyEncoders);
    }

    static ICodecExecutor createCodecExecutor(int shift, boolean onlyEncoders) {
        DefaultCodecExecutor executor = new DefaultCodecExecutor();
        if (!onlyEncoders) {
            executor.getPipeline().add((Object)DECODER, (IDecoder)new Decoder(shift));
        }
        executor.getPipeline().add((Object)ENCODER, (IEncoder)new Encoder(shift));
        return executor;
    }

    static void updateCodecPipeline(ICodecPipeline pipeline, String protocol) {
        SessionConfig.updateCodecPipeline(pipeline, SessionConfig.shift(protocol));
    }

    static void updateCodecPipeline(ICodecPipeline pipeline, int shift) {
        pipeline.replace((Object)DECODER, (Object)DECODER, (IDecoder)new Decoder(shift));
        pipeline.replace((Object)ENCODER, (Object)ENCODER, (IEncoder)new Encoder(shift));
    }
}

