/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.file;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.SocketAddress;
import java.nio.channels.FileChannel;
import org.snf4j.core.allocator.CachingAllocator;
import org.snf4j.core.allocator.IByteBufferAllocator;
import org.snf4j.core.allocator.IDefaultAllocatorMetricCollector;
import org.snf4j.core.factory.DefaultSessionStructureFactory;
import org.snf4j.core.factory.ISessionStructureFactory;
import org.snf4j.core.handler.AbstractStreamHandler;
import org.snf4j.core.handler.SessionEvent;
import org.snf4j.core.session.DefaultSessionConfig;
import org.snf4j.core.session.ISessionConfig;
import org.snf4j.core.session.ssl.SSLEngineBuilder;
import org.snf4j.core.timer.DefaultTimer;
import org.snf4j.core.timer.ITimer;
import org.snf4j.example.file.AllocatorMetric;

public abstract class AbstractFileHandler
extends AbstractStreamHandler {
    protected static final int BUFFER_SIZE = 4096;
    protected static final AllocatorMetric METRIC = new AllocatorMetric();
    private static final IByteBufferAllocator ALLOCATOR = new CachingAllocator(true, (IDefaultAllocatorMetricCollector)METRIC);
    private static final ITimer TIMER = new DefaultTimer(true);
    protected final DefaultSessionConfig config = new DefaultSessionConfig().setOptimizeDataCopying(true);
    protected RandomAccessFile file;
    protected FileChannel fileChannel;
    protected long fileLength;
    protected SocketAddress remoteAddress;
    protected long startTime;

    AbstractFileHandler(SSLEngineBuilder builder) {
        if (builder != null) {
            this.config.addSSLEngineBuilder(builder);
        }
    }

    public void event(SessionEvent event) {
        switch (event) {
            case OPENED: {
                this.remoteAddress = this.getSession().getRemoteAddress();
                break;
            }
            case CLOSED: {
                if (this.fileChannel == null) break;
                try {
                    this.fileChannel.close();
                    this.file.close();
                }
                catch (IOException iOException) {}
                break;
            }
        }
    }

    public ISessionConfig getConfig() {
        return this.config;
    }

    public ISessionStructureFactory getFactory() {
        return new DefaultSessionStructureFactory(){

            public ITimer getTimer() {
                return TIMER;
            }

            public IByteBufferAllocator getAllocator() {
                return ALLOCATOR;
            }
        };
    }
}

