/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.sctp;

import com.sun.nio.sctp.MessageInfo;
import java.nio.ByteBuffer;
import org.snf4j.core.EndingAction;
import org.snf4j.core.handler.SessionEvent;
import org.snf4j.core.session.ISctpSessionConfig;
import org.snf4j.example.sctp.SctpClient;
import org.snf4j.example.sctp.SctpServerHandler;
import org.snf4j.example.sctp.SessionConfig;

public class SctpClientHandler
extends SctpServerHandler {
    private int statsCount;
    private int msgCounter;
    private int[] msgCounters = new int[3];
    private static final String[] streams = new String[]{"compressed", "encoded(unordered)", "other"};

    public void event(SessionEvent event) {
        switch (event) {
            case READY: {
                this.getSession().writenf(this.msg(), this.randomStream());
            }
        }
    }

    @Override
    public void read(Object msg, MessageInfo msgInfo) {
        this.stats(((ByteBuffer)msg).remaining(), msgInfo);
        super.read(msg, msgInfo);
    }

    void stats(int msgSize, MessageInfo msgInfo) {
        ++this.msgCounter;
        if (msgInfo.streamNumber() == 1) {
            if (msgInfo.isUnordered()) {
                this.msgCounters[1] = this.msgCounters[1] + 1;
            } else {
                this.msgCounters[0] = this.msgCounters[0] + 1;
            }
        } else {
            this.msgCounters[2] = this.msgCounters[2] + 1;
        }
        if (this.statsCount++ > 10000) {
            StringBuilder sb = new StringBuilder();
            sb.append("messages: ");
            sb.append("total=");
            sb.append(this.msgCounter / 1000);
            sb.append("K\t");
            for (int i = 0; i < streams.length; ++i) {
                sb.append(streams[i]);
                sb.append("=");
                sb.append(this.msgCounters[i] / 1000);
                sb.append("K\t");
            }
            System.out.println(sb);
            this.statsCount = 0;
        }
    }

    @Override
    public ISctpSessionConfig getConfig() {
        return (ISctpSessionConfig)new SessionConfig().setEndingAction(EndingAction.STOP).setOptimizeDataCopying(true).setMinOutBufferCapacity(SctpClient.SIZE << 1);
    }
}

