/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.earlydata;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.snf4j.core.codec.IBaseDecoder;
import org.snf4j.core.session.ISession;

public class Decoder
implements IBaseDecoder<ByteBuffer, String> {
    private final int shift;

    Decoder(int shift) {
        this.shift = shift;
    }

    public void decode(ISession session, ByteBuffer data, List<String> out) throws Exception {
        byte[] bytes = new byte[data.remaining() - 2];
        data.position(2);
        data.get(bytes);
        session.release(data);
        int i = 0;
        while (i < bytes.length) {
            int n = i++;
            bytes[n] = (byte)(bytes[n] - this.shift);
        }
        out.add(new String(bytes, StandardCharsets.US_ASCII));
    }

    public Class<ByteBuffer> getInboundType() {
        return ByteBuffer.class;
    }

    public Class<String> getOutboundType() {
        return String.class;
    }

    public int available(ISession session, ByteBuffer buffer, boolean flipped) {
        int length;
        int position;
        int remaining;
        if (flipped) {
            remaining = buffer.remaining();
            position = buffer.position();
        } else {
            remaining = buffer.position();
            position = 0;
        }
        if (remaining >= 2 && remaining >= (length = buffer.getShort(position) + 2)) {
            return length;
        }
        return 0;
    }

    public int available(ISession session, byte[] buffer, int off, int len) {
        int length;
        if (buffer.length >= 2 && buffer.length >= (length = ByteBuffer.wrap(buffer).getShort() + 2)) {
            return length;
        }
        return 0;
    }
}

