/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.earlydata;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.snf4j.core.SelectorLoop;
import org.snf4j.core.StreamSession;
import org.snf4j.core.handler.IStreamHandler;
import org.snf4j.example.earlydata.EarlyDataClientHandler;
import org.snf4j.example.earlydata.KeyStoreLoader;
import org.snf4j.example.earlydata.Logger;
import org.snf4j.tls.TLSSession;
import org.snf4j.tls.engine.DelegatedTaskMode;
import org.snf4j.tls.engine.EngineHandlerBuilder;
import org.snf4j.tls.engine.EngineParameters;
import org.snf4j.tls.engine.EngineParametersBuilder;
import org.snf4j.tls.engine.IApplicationProtocolHandler;
import org.snf4j.tls.engine.IEarlyDataHandler;
import org.snf4j.tls.engine.IEngineHandler;
import org.snf4j.tls.engine.IEngineParameters;

public class EarlyDataClient {
    static final String PREFIX = "org.snf4j.";
    static final String HOST = System.getProperty("org.snf4j.Host", "localhost");
    static final int PORT = Integer.getInteger("org.snf4j.Port", 8001);

    public static void main(String[] args) throws Exception {
        SelectorLoop loop = new SelectorLoop();
        try {
            loop.start();
            Logger.inf("----- connect #1 --------------------------");
            EarlyDataClient.connect(loop, "time", "p2");
            Logger.inf("----- connect #2 (accepted) ---------------");
            EarlyDataClient.connect(loop, "time", "p2");
            Logger.inf("----- connect #3 (rejected) ---------------");
            EarlyDataClient.connect(loop, "time", "p3");
            Logger.inf("----- connect #4 (accepted) ---------------");
            EarlyDataClient.connect(loop, "time", "p3");
            Logger.inf("----- connect #5 (accepted) ---------------");
            EarlyDataClient.connect(loop, "time", "p3");
        }
        finally {
            loop.stop();
        }
    }

    static TLSSession connect(SelectorLoop loop, String cmd, String protocol) throws Exception {
        SocketChannel channel = SocketChannel.open();
        channel.configureBlocking(false);
        channel.connect(new InetSocketAddress(InetAddress.getByName(HOST), PORT));
        EngineParameters params = new EngineParametersBuilder().delegatedTaskMode(DelegatedTaskMode.ALL).peerHost(HOST).peerPort(PORT).applicationProtocols(new String[]{protocol}).build();
        EngineHandlerBuilder builder = new EngineHandlerBuilder(KeyStoreLoader.keyManager(), KeyStoreLoader.trustManager()).padding(1);
        EarlyDataClientHandler handler = new EarlyDataClientHandler(cmd);
        TLSSession session = new TLSSession((IEngineParameters)params, (IEngineHandler)builder.build((IEarlyDataHandler)handler, (IApplicationProtocolHandler)handler), (IStreamHandler)handler, true);
        loop.register(channel, (StreamSession)session);
        session.getEndFuture().sync();
        return session;
    }
}

