/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.earlydata;

import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import org.snf4j.core.SelectorLoop;
import org.snf4j.core.factory.IStreamSessionFactory;
import org.snf4j.example.earlydata.KeyStoreLoader;
import org.snf4j.example.earlydata.SessionFactory;
import org.snf4j.tls.engine.DelegatedTaskMode;
import org.snf4j.tls.engine.EngineHandlerBuilder;
import org.snf4j.tls.engine.EngineParameters;
import org.snf4j.tls.engine.EngineParametersBuilder;

public class EarlyDataServer {
    static final String PREFIX = "org.snf4j.";
    static final int PORT = Integer.getInteger("org.snf4j.Port", 8001);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SelectorLoop loop = new SelectorLoop();
        Object pool = null;
        try {
            loop.start();
            ServerSocketChannel channel = ServerSocketChannel.open();
            channel.configureBlocking(false);
            channel.socket().bind(new InetSocketAddress(PORT));
            EngineParameters params = new EngineParametersBuilder().delegatedTaskMode(DelegatedTaskMode.ALL).applicationProtocols(new String[]{"p1", "p2", "p3"}).build();
            EngineHandlerBuilder builder = new EngineHandlerBuilder(KeyStoreLoader.keyManager(), KeyStoreLoader.trustManager()).ticketInfos(new long[]{1024L}).maxEarlyDataSize(1024L).padding(1);
            loop.register(channel, (IStreamSessionFactory)new SessionFactory(params, builder));
            loop.join();
        }
        finally {
            loop.stop();
            if (pool != null) {
                pool.stop();
            }
        }
    }
}

