/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.engine;

import java.nio.ByteBuffer;
import java.util.Random;
import org.snf4j.core.engine.IEngineResult;
import org.snf4j.example.engine.CloseableEngine;
import org.snf4j.example.engine.Packet;
import org.snf4j.example.engine.Result;

public class HandshakingEngine
extends CloseableEngine {
    private final boolean clientMode;
    private HandshakeState state = HandshakeState.NONE;

    public HandshakingEngine(int offset, boolean clientMode) {
        super(offset);
        this.clientMode = clientMode;
    }

    private IEngineResult clientHandshaking(ByteBuffer src, ByteBuffer dst) {
        switch (this.state) {
            case NONE: {
                int offsetInc = new Random().nextInt(254) + 1;
                int prevPosition = dst.position();
                dst.put(Packet.encode(this.offset, new byte[]{(byte)offsetInc}));
                this.offset += offsetInc;
                this.state = HandshakeState.PENDING;
                return Result.needUnwrap(dst.position() - prevPosition);
            }
            case PENDING: {
                int prevRemaining = src.remaining();
                int size = Packet.decodeSize(this.offset, src);
                if (size == -1) {
                    return Result.BUFFER_UNDERFLOW_NEED_UNWRAP;
                }
                byte[] decoded = Packet.decode(this.offset, src, size);
                if (decoded.length != 1 || decoded[0] != 0) {
                    throw new IllegalArgumentException();
                }
                this.state = HandshakeState.FINISHED;
                return Result.finished(prevRemaining - src.remaining(), 0);
            }
        }
        return null;
    }

    private IEngineResult serverHandshaking(ByteBuffer src, ByteBuffer dst) {
        switch (this.state) {
            case NONE: {
                this.state = HandshakeState.PENDING;
                return Result.needUnwrap(0);
            }
            case PENDING: {
                int prevRemaining = src.remaining();
                int size = Packet.decodeSize(this.offset, src);
                if (size == -1) {
                    return Result.BUFFER_UNDERFLOW_NEED_UNWRAP;
                }
                byte[] decoded = Packet.decode(this.offset, src, size);
                if (decoded.length != 1) {
                    throw new IllegalArgumentException();
                }
                this.offset += decoded[0];
                this.state = HandshakeState.FINISHING;
                return Result.needWrap(prevRemaining - src.remaining());
            }
            case FINISHING: {
                int prevPosition = dst.position();
                dst.put(Packet.encode(this.offset, new byte[]{0}));
                this.state = HandshakeState.FINISHED;
                return Result.finished(0, dst.position() - prevPosition);
            }
        }
        return null;
    }

    @Override
    public IEngineResult preWrap(ByteBuffer[] srcs, ByteBuffer dst) {
        IEngineResult result;
        IEngineResult iEngineResult = result = this.clientMode ? this.clientHandshaking(null, dst) : this.serverHandshaking(null, dst);
        if (result != null) {
            return result;
        }
        return super.preWrap(srcs, dst);
    }

    @Override
    public IEngineResult preUnwrap(ByteBuffer src, ByteBuffer dst) {
        IEngineResult result;
        IEngineResult iEngineResult = result = this.clientMode ? this.clientHandshaking(src, dst) : this.serverHandshaking(src, dst);
        if (result != null) {
            return result;
        }
        return super.preUnwrap(src, dst);
    }

    protected static enum HandshakeState {
        NONE,
        PENDING,
        FINISHING,
        FINISHED;

    }
}

