/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.file;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.snf4j.core.SSLSession;
import org.snf4j.core.SelectorLoop;
import org.snf4j.core.StreamSession;
import org.snf4j.core.handler.IStreamHandler;
import org.snf4j.core.session.ssl.SSLContextBuilder;
import org.snf4j.core.session.ssl.SSLEngineBuilder;
import org.snf4j.example.file.FileClientHandler;
import org.snf4j.example.file.KeyStoreLoader;
import org.snf4j.example.file.Logger;

public class FileClient {
    static final String PREFIX = "org.snf4j.";
    static final String HOST = System.getProperty("org.snf4j.Host", "127.0.0.1");
    static final int PORT = Integer.getInteger("org.snf4j.Port", 8001);
    static final boolean SECURE = System.getProperty("org.snf4j.Secure") != null;
    static final String DOWNLOAD_DIR = System.getProperty("org.snf4j.DownloadDir", ".");
    static final boolean DELETE_IF_EXISTS = System.getProperty("org.snf4j.DeleteIfExists") != null;
    static final boolean DISCARD = System.getProperty("org.snf4j.Discard") != null;
    static final int BUFFER_SIZE = Integer.getInteger("org.snf4j.BufferSize", 4096);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            Logger.error("No path specified");
            return;
        }
        SelectorLoop loop = new SelectorLoop();
        try {
            loop.start();
            SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            channel.connect(new InetSocketAddress(InetAddress.getByName(HOST), PORT));
            if (SECURE) {
                SSLEngineBuilder builder = SSLContextBuilder.forClient().keyManager(KeyStoreLoader.keyManagerFactory()).trustManager(KeyStoreLoader.trustManagerFactory()).engineBuilder();
                loop.register(channel, (StreamSession)new SSLSession((IStreamHandler)new FileClientHandler(builder, args[0]), true));
            } else {
                loop.register(channel, (IStreamHandler)new FileClientHandler(null, args[0]));
            }
            loop.join();
        }
        finally {
            loop.stop();
        }
    }
}

