/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.snf4j.core.ByteBufferHolder;
import org.snf4j.core.IByteBufferHolder;
import org.snf4j.core.future.IFuture;
import org.snf4j.core.handler.DataEvent;
import org.snf4j.core.handler.SessionEvent;
import org.snf4j.core.session.ssl.SSLEngineBuilder;
import org.snf4j.example.file.AbstractFileHandler;
import org.snf4j.example.file.FileServer;
import org.snf4j.example.file.Logger;

class FileServerHandler
extends AbstractFileHandler {
    private static final int DEFAULT_HALF2_SIZE = FileServer.BUFFER_COUNT / 2;
    private static final int DEFAULT_HALF1_SIZE = FileServer.BUFFER_COUNT - DEFAULT_HALF2_SIZE;
    private final StringBuilder path = new StringBuilder(256);
    private int half1Size = DEFAULT_HALF1_SIZE;
    private int half2Size = DEFAULT_HALF2_SIZE;
    private IFuture<Void> fullProgress;
    private IFuture<Void> halfProgress;

    FileServerHandler(SSLEngineBuilder builder) {
        super(builder);
        this.config.setMinInBufferCapacity(FileServer.BUFFER_SIZE).setMinOutBufferCapacity(FileServer.BUFFER_SIZE);
    }

    public void read(Object msg) {
        if (this.fileChannel != null) {
            this.getSession().release((ByteBuffer)msg);
            return;
        }
        byte[] data = new byte[((ByteBuffer)msg).remaining()];
        ((ByteBuffer)msg).get(data);
        this.getSession().release((ByteBuffer)msg);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 0) continue;
            this.path.append(new String(data, 0, i, StandardCharsets.UTF_8));
            try {
                this.file = new RandomAccessFile(this.path.toString(), "r");
                this.fileChannel = this.file.getChannel();
                this.info("Uploading " + this.path);
                this.startTime = System.currentTimeMillis();
                this.progress(true);
            }
            catch (FileNotFoundException e) {
                this.err(e);
                this.getSession().close();
            }
            return;
        }
        this.path.append(new String(data, StandardCharsets.UTF_8));
    }

    @Override
    public void event(SessionEvent event) {
        if (event == SessionEvent.CLOSED && this.file != null) {
            long time = System.currentTimeMillis() - this.startTime;
            this.info(String.format("Uploading of %,d bytes completed in %,d msec (%,d bytes/sec)", this.fileLength, time, this.fileLength * 1000L / time));
            this.info(String.format("Allocator statistics: phisical allocations: %d (total %,d bytes), total allocations (from cache): %,d", METRIC.getAllocatedCount(), METRIC.getAllocatedSize(), METRIC.getAllocatingCount()));
        }
        super.event(event);
    }

    public void event(DataEvent event, long length) {
        if (event == DataEvent.SENT && this.halfProgress != null && this.halfProgress.isSuccessful()) {
            if (this.fullProgress.isSuccessful()) {
                this.half1Size = DEFAULT_HALF1_SIZE;
                this.half2Size = DEFAULT_HALF2_SIZE;
                this.fullProgress = null;
                this.halfProgress = null;
                this.progress(true);
            } else {
                int tmpCount = this.half1Size;
                this.half1Size = this.half2Size;
                this.half2Size = tmpCount;
                this.halfProgress = this.fullProgress;
                this.progress(false);
            }
        }
    }

    private void progress(boolean full) {
        int count = full ? FileServer.BUFFER_COUNT : this.half2Size;
        ByteBufferHolder holder = new ByteBufferHolder(count);
        boolean eof = false;
        try {
            for (int i = 0; i < count; ++i) {
                ByteBuffer buf = this.getSession().allocate(4096);
                int bytes = this.fileChannel.read(buf);
                if (bytes > 0) {
                    this.fileLength += (long)bytes;
                    buf.flip();
                    holder.add(buf);
                    continue;
                }
                this.getSession().release(buf);
                if (bytes != -1) continue;
                eof = true;
                break;
            }
            if (eof) {
                this.getSession().writenf((IByteBufferHolder)holder);
                this.getSession().close();
                this.halfProgress = null;
                this.fullProgress = null;
            } else if (full) {
                int size = holder.size();
                if (size <= this.half1Size) {
                    this.fullProgress = this.halfProgress = this.getSession().write((IByteBufferHolder)holder);
                } else {
                    ByteBufferHolder holder2 = new ByteBufferHolder();
                    for (int i = this.half1Size; i < size; ++i) {
                        holder2.add(holder.remove(this.half1Size));
                    }
                    this.halfProgress = this.getSession().write((IByteBufferHolder)holder);
                    this.fullProgress = this.getSession().write((IByteBufferHolder)holder2);
                }
            } else {
                this.fullProgress = this.getSession().write((IByteBufferHolder)holder);
            }
        }
        catch (IOException e) {
            this.err(e);
            for (ByteBuffer buf : holder) {
                this.getSession().release(buf);
            }
            this.getSession().close();
        }
    }

    public void exception(Throwable t) {
        this.err(t);
    }

    void err(String msg) {
        Logger.error("[" + this.remoteAddress + "] " + msg);
    }

    void err(Throwable t) {
        Logger.error("[" + this.remoteAddress + "] " + t);
    }

    void info(String msg) {
        Logger.info("[" + this.remoteAddress + "] " + msg);
    }
}

