/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.websocket;

import java.io.InputStream;
import java.net.URI;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import org.snf4j.core.session.SSLEngineCreateException;
import org.snf4j.websocket.DefaultWebSocketSessionConfig;

public class SessionConfig
extends DefaultWebSocketSessionConfig {
    static final String CHAT_PATH = "/chat";
    static final String ECHO_PATH = "/echo";
    static volatile SSLContext sslContext = null;

    public SessionConfig(URI requestUri) {
        super(requestUri);
    }

    public SessionConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(KeyStore ks, String fileName, char[] password) throws Exception {
        try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);){
            ks.load(in, password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSLContext getSSLContext() throws SSLEngineCreateException {
        if (sslContext == null) {
            try {
                Class<SessionConfig> clazz = SessionConfig.class;
                synchronized (SessionConfig.class) {
                    if (sslContext == null) {
                        KeyStore ks = KeyStore.getInstance("JKS");
                        KeyStore ts = KeyStore.getInstance("JKS");
                        char[] password = "password".toCharArray();
                        this.load(ks, "/keystore.jks", password);
                        this.load(ts, "/keystore.jks", password);
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                        kmf.init(ks, password);
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                        tmf.init(ts);
                        SSLContext ctx = SSLContext.getInstance("TLS");
                        ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                        sslContext = ctx;
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                throw new SSLEngineCreateException((Throwable)e);
            }
        }
        {
            return sslContext;
        }
    }

    public SSLEngine createSSLEngine(boolean clientMode) throws SSLEngineCreateException {
        SSLEngine engine = this.getSSLContext().createSSLEngine();
        engine.setUseClientMode(clientMode);
        if (!clientMode) {
            engine.setNeedClientAuth(true);
        }
        return engine;
    }

    public boolean acceptRequestUri(URI uri) {
        String path = uri.getPath();
        return ECHO_PATH.equalsIgnoreCase(path) || CHAT_PATH.equalsIgnoreCase(path);
    }
}

