/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.discarding;

import org.snf4j.core.EndingAction;
import org.snf4j.core.handler.AbstractStreamHandler;
import org.snf4j.core.handler.DataEvent;
import org.snf4j.core.handler.SessionEvent;
import org.snf4j.core.session.DefaultSessionConfig;
import org.snf4j.core.session.ISessionConfig;
import org.snf4j.example.discarding.DiscardingClient;

public class DiscardingClientHandler
extends AbstractStreamHandler {
    private byte[] data = new byte[DiscardingClient.SIZE];
    private long bytesSent;
    private long totalBytesSent;
    private double maxThroughput;
    private long startTime;

    public void read(byte[] data) {
    }

    public void event(SessionEvent event) {
        switch (event) {
            case OPENED: {
                this.startTime = System.currentTimeMillis();
                this.getSession().write(this.data);
                break;
            }
            case ENDING: {
                long endTime = System.currentTimeMillis();
                long avgThroughput = 1000L * this.totalBytesSent / (endTime - this.startTime);
                System.out.println("Max throughput [bytes/secs]: " + (long)this.maxThroughput);
                System.out.println("Avg throughput [bytes/secs]: " + avgThroughput);
            }
        }
    }

    public void event(DataEvent event, long size) {
        switch (event) {
            case SENT: {
                double throughput = this.getSession().getWrittenBytesThroughput();
                if (throughput > this.maxThroughput) {
                    this.maxThroughput = throughput;
                }
                this.totalBytesSent += size;
                if (this.totalBytesSent >= DiscardingClient.TOTAL_SIZE) {
                    this.getSession().close();
                    break;
                }
                this.bytesSent += size;
                if (this.bytesSent != (long)this.data.length) break;
                this.bytesSent = 0L;
                this.getSession().write(this.data);
            }
        }
    }

    public ISessionConfig getConfig() {
        return new DefaultSessionConfig().setEndingAction(EndingAction.STOP);
    }
}

