/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.dtls;

import java.net.SocketAddress;
import org.snf4j.core.EndingAction;
import org.snf4j.core.factory.ISessionStructureFactory;
import org.snf4j.core.handler.AbstractDatagramHandler;
import org.snf4j.core.handler.SessionEvent;
import org.snf4j.core.handler.SessionIncident;
import org.snf4j.core.session.ISessionConfig;
import org.snf4j.core.timer.ITimerTask;
import org.snf4j.example.dtls.Packet;
import org.snf4j.example.dtls.SessionConfig;
import org.snf4j.example.dtls.SessionStructureFactory;

public class SessionHandler
extends AbstractDatagramHandler {
    static final Object RETRY_EVENT = new Object();
    static final int RETRY_COUNT = 5;
    static final int RETRY_TIMEOUT = 1000;
    static final Object IDLE_EVENT = new Object();
    static final int IDLE_TIMEOUT = 30000;
    final boolean clientMode;
    long sequence;
    long retries;
    ITimerTask retryTimer;
    ITimerTask idleTimer;
    int retryLeft;

    SessionHandler(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public void read(SocketAddress remoteAddress, Object msg) {
    }

    public void read(Object msg) {
        if (this.clientMode) {
            this.handleClient((Packet)msg);
        } else {
            this.handleServer((Packet)msg);
        }
    }

    void setRetryTimer(boolean resetCounter) {
        if (resetCounter) {
            this.retryLeft = 5;
        }
        if (this.retryTimer != null) {
            this.retryTimer.cancelTask();
        }
        this.retryTimer = this.getSession().getTimer().scheduleEvent(RETRY_EVENT, 1000L);
    }

    void setIdleTimer() {
        this.idleTimer = this.getSession().getTimer().scheduleEvent(IDLE_EVENT, 1000L, 5000L);
    }

    void cancelTimers() {
        if (this.retryTimer != null) {
            this.retryTimer.cancelTask();
        }
        if (this.idleTimer != null) {
            this.idleTimer.cancelTask();
        }
    }

    void handleClient(Packet packet) {
        if (packet.getSequence() == this.sequence) {
            this.getSession().writenf((Object)new Packet(++this.sequence, 512));
            this.setRetryTimer(true);
            this.stats();
        }
    }

    void handleServer(Packet packet) {
        if (packet.getSequence() == this.sequence + 1L) {
            this.getSession().writenf((Object)new Packet(++this.sequence, 512));
        }
    }

    public void timer(Object event) {
        if (event == RETRY_EVENT) {
            ++this.retries;
            this.retryTimer = null;
            if (this.retryLeft > 0) {
                --this.retryLeft;
            } else {
                this.getSession().close();
                return;
            }
            this.log("retry " + (5 - this.retryLeft));
            this.getSession().writenf((Object)new Packet(this.sequence, 512));
            this.setRetryTimer(false);
        } else if (event == IDLE_EVENT && System.currentTimeMillis() - this.getSession().getLastReadTime() > 30000L) {
            this.log("idle");
            this.getSession().close();
        }
    }

    public void event(SessionEvent event) {
        switch (event) {
            case OPENED: {
                this.log("open");
                break;
            }
            case READY: {
                this.log("ready");
                if (this.clientMode) {
                    this.getSession().writenf((Object)new Packet(++this.sequence, 512));
                    this.setRetryTimer(true);
                    break;
                }
                this.setIdleTimer();
                break;
            }
            case CLOSED: {
                this.log("closed");
                break;
            }
            case ENDING: {
                this.cancelTimers();
            }
        }
    }

    public void exception(Throwable e) {
        this.err(e);
    }

    public boolean incident(SessionIncident incident, Throwable t) {
        this.err(incident + ": " + t);
        return true;
    }

    public ISessionStructureFactory getFactory() {
        return SessionStructureFactory.INSTANCE;
    }

    public ISessionConfig getConfig() {
        return new SessionConfig().setOptimizeDataCopying(true).setEndingAction(this.clientMode ? EndingAction.STOP : EndingAction.DEFAULT);
    }

    void log(Object s) {
        if (this.clientMode) {
            System.out.println("[INF] " + s);
        } else {
            System.out.println("[INF] " + this.getSession().getName() + ": " + s);
        }
    }

    void err(Object s) {
        if (this.clientMode) {
            System.out.println("[ERR] " + s);
        } else {
            System.out.println("[ERR] " + this.getSession().getName() + ": " + s);
        }
    }

    void stats() {
        if (this.sequence % 10000L == 0L) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("packets:");
            sb.append(this.sequence / 1000L);
            sb.append("K retries: ");
            sb.append(this.retries);
            sb.append(" bytes: ");
            sb.append(this.getSession().getReadBytes() / 0x100000L);
            sb.append("M speed: ");
            sb.append((long)this.getSession().getReadBytesThroughput() / 1024L);
            sb.append(" [KB/s]");
            this.log(sb.toString());
        }
    }
}

