/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.engine;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.snf4j.core.SelectorLoop;
import org.snf4j.core.StreamSession;
import org.snf4j.core.handler.IStreamHandler;
import org.snf4j.example.engine.EngineClientHandler;
import org.snf4j.example.engine.EngineFactory;
import org.snf4j.example.engine.EngineSession;

public class EngineClient {
    static final String PREFIX = "org.snf4j.";
    static final String HOST = System.getProperty("org.snf4j.Host", "127.0.0.1");
    static final int PORT = Integer.getInteger("org.snf4j.Port", 8003);
    static final int ENGINE = Integer.getInteger("org.snf4j.Engine", 2);
    static final int OFFSET = Integer.getInteger("org.snf4j.Offset", 66);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SelectorLoop loop = new SelectorLoop();
        try {
            loop.start();
            SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            channel.connect(new InetSocketAddress(InetAddress.getByName(HOST), PORT));
            EngineSession session = new EngineSession(EngineFactory.create(ENGINE, OFFSET, true), (IStreamHandler)new EngineClientHandler());
            loop.register(channel, (StreamSession)session).sync().getSession();
            session.getReadyFuture().sync();
            session.write("Hello, World!".getBytes()).sync();
            session.quickClose();
            session.getCloseFuture().sync();
        }
        finally {
            loop.stop();
        }
    }
}

