/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.chat;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.snf4j.core.SelectorLoop;
import org.snf4j.core.handler.IStreamHandler;
import org.snf4j.core.session.IStreamSession;
import org.snf4j.example.chat.ChatClientHandler;

public class ChatClient {
    static final String PREFIX = "org.snf4j.";
    static final String HOST = System.getProperty("org.snf4j.Host", "127.0.0.1");
    static final int PORT = Integer.getInteger("org.snf4j.Port", 8002);
    static final Integer BYE_TYPED = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SelectorLoop loop = new SelectorLoop();
        try {
            String line;
            loop.start();
            SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            channel.connect(new InetSocketAddress(InetAddress.getByName(HOST), PORT));
            IStreamSession session = (IStreamSession)loop.register(channel, (IStreamHandler)new ChatClientHandler()).sync().getSession();
            session.getReadyFuture().sync();
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while ((line = in.readLine()) != null) {
                if (session.isOpen()) {
                    session.write(line.getBytes());
                }
                if (!"bye".equalsIgnoreCase(line)) continue;
                session.getAttributes().put(BYE_TYPED, BYE_TYPED);
                break;
            }
        }
        finally {
            loop.stop();
        }
    }
}

