/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.echo;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.snf4j.core.SSLSession;
import org.snf4j.core.SelectorLoop;
import org.snf4j.core.StreamSession;
import org.snf4j.core.handler.IStreamHandler;
import org.snf4j.example.echo.EchoClientHandler;

public class EchoClient {
    static final String PREFIX = "org.snf4j.";
    static final String HOST = System.getProperty("org.snf4j.Host", "127.0.0.1");
    static final int PORT = Integer.getInteger("org.snf4j.Port", 8001);
    static final int SIZE = Integer.getInteger("org.snf4j.Size", 512);
    static final long TOTAL_SIZE = Long.getLong("org.snf4j.TotalSize", 0x40000000L);
    static final boolean SECURE = Integer.getInteger("org.snf4j.Secure") != null;
    static final int PIPELINE_SIZE = Integer.getInteger("org.snf4j.PipelineSize", 0);

    public static void main(String[] args) throws Exception {
        SelectorLoop loop = new SelectorLoop();
        try {
            loop.start();
            SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            channel.connect(new InetSocketAddress(InetAddress.getByName(HOST), PORT));
            if (SECURE) {
                loop.register(channel, (StreamSession)new SSLSession((IStreamHandler)new EchoClientHandler(), true));
            } else {
                loop.register(channel, (IStreamHandler)new EchoClientHandler());
            }
            loop.join();
        }
        finally {
            loop.stop();
        }
    }
}

