/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.echo;

import java.nio.ByteBuffer;
import org.snf4j.core.EndingAction;
import org.snf4j.core.allocator.IByteBufferAllocator;
import org.snf4j.core.allocator.ThreadLocalCachingAllocator;
import org.snf4j.core.factory.DefaultSessionStructureFactory;
import org.snf4j.core.factory.ISessionStructureFactory;
import org.snf4j.core.handler.AbstractStreamHandler;
import org.snf4j.core.handler.SessionEvent;
import org.snf4j.core.handler.SessionIncident;
import org.snf4j.core.session.ISessionConfig;
import org.snf4j.example.echo.EchoClient;
import org.snf4j.example.echo.Logger;
import org.snf4j.example.echo.SessionConfig;

public class EchoClientHandler
extends AbstractStreamHandler {
    private static final IByteBufferAllocator ALLOCATOR = new ThreadLocalCachingAllocator(true);
    private long startTime;
    private long totalBytes;

    boolean read(int size) {
        this.totalBytes += (long)size;
        if (this.totalBytes >= EchoClient.TOTAL_SIZE) {
            this.getSession().close();
            return false;
        }
        return true;
    }

    public void read(ByteBuffer data) {
        if (this.read(data.remaining())) {
            super.read(data);
        }
    }

    public void read(Object msg) {
        this.getSession().writenf(msg);
    }

    public void event(SessionEvent event) {
        switch (event) {
            case READY: {
                ByteBuffer msg = this.getSession().allocate(EchoClient.SIZE);
                Logger.inf("starting...");
                this.startTime = System.currentTimeMillis();
                for (int i = 0; i < msg.capacity(); ++i) {
                    msg.put((byte)i);
                }
                msg.flip();
                this.getSession().writenf(msg);
                break;
            }
            case CLOSED: {
                this.stats();
            }
        }
    }

    public void exception(Throwable e) {
        Logger.err(e.toString());
    }

    public boolean incident(SessionIncident incident, Throwable t) {
        Logger.err(incident + ": " + t.toString());
        return true;
    }

    private void stats() {
        long bytesPerSecond = 1000L * this.totalBytes / (System.currentTimeMillis() - this.startTime);
        Logger.inf("avg bytes/sec: " + bytesPerSecond);
    }

    public ISessionConfig getConfig() {
        return new SessionConfig(EchoClient.PIPELINE_SIZE).setEndingAction(EndingAction.STOP).setOptimizeDataCopying(true).setMinOutBufferCapacity(EchoClient.SIZE << 1);
    }

    public ISessionStructureFactory getFactory() {
        return new DefaultSessionStructureFactory(){

            public IByteBufferAllocator getAllocator() {
                return ALLOCATOR;
            }
        };
    }
}

