/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.echo;

import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.snf4j.core.SelectorLoop;
import org.snf4j.core.factory.AbstractSessionFactory;
import org.snf4j.core.factory.IStreamSessionFactory;
import org.snf4j.core.handler.IStreamHandler;
import org.snf4j.core.pool.DefaultSelectorLoopPool;
import org.snf4j.core.pool.ISelectorLoopPool;
import org.snf4j.example.echo.EchoServerHandler;

public class EchoServer {
    static final String PREFIX = "org.snf4j.";
    static final int PORT = Integer.getInteger("org.snf4j.Port", 8001);
    static final int POOL_SIZE = Integer.getInteger("org.snf4j.PoolSize", 8);
    static final boolean SECURE = Integer.getInteger("org.snf4j.Secure") != null;
    static final int PIPELINE_SIZE = Integer.getInteger("org.snf4j.PipelineSize", 0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SelectorLoop loop = new SelectorLoop();
        DefaultSelectorLoopPool pool = null;
        try {
            loop.start();
            if (POOL_SIZE > 0) {
                pool = new DefaultSelectorLoopPool(POOL_SIZE);
                loop.setPool((ISelectorLoopPool)pool);
            }
            ServerSocketChannel channel = ServerSocketChannel.open();
            channel.configureBlocking(false);
            channel.socket().bind(new InetSocketAddress(PORT));
            loop.register(channel, (IStreamSessionFactory)new AbstractSessionFactory(SECURE){

                protected IStreamHandler createHandler(SocketChannel channel) {
                    return new EchoServerHandler();
                }
            });
            loop.join();
        }
        finally {
            loop.stop();
            if (pool != null) {
                pool.stop();
            }
        }
    }
}

