/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.engine;

import java.nio.ByteBuffer;
import org.snf4j.core.engine.EngineResult;
import org.snf4j.core.engine.IEngineResult;
import org.snf4j.core.engine.Status;
import org.snf4j.example.engine.AbstractEngine;
import org.snf4j.example.engine.Packet;
import org.snf4j.example.engine.Result;

public class BasicEngine
extends AbstractEngine {
    protected int offset;
    private boolean finished;

    public BasicEngine(int offset) {
        this.offset = offset;
    }

    protected IEngineResult closeWrap(ByteBuffer dst) {
        return Result.CLOSED;
    }

    protected IEngineResult preWrap(ByteBuffer[] srcs, ByteBuffer dst) {
        if (this.outboundDone == AbstractEngine.CloseType.PENDING) {
            IEngineResult result = this.closeWrap(dst);
            if (result.getStatus() == Status.CLOSED) {
                this.outboundDone = AbstractEngine.CloseType.DONE;
            }
            return result;
        }
        if (this.outboundDone == AbstractEngine.CloseType.DONE) {
            return Result.CLOSED;
        }
        if (!this.finished) {
            this.finished = true;
            return Result.FINISHED;
        }
        return null;
    }

    public IEngineResult wrap(ByteBuffer[] srcs, ByteBuffer dst) throws Exception {
        int consumed;
        IEngineResult preResult = this.preWrap(srcs, dst);
        if (preResult != null) {
            return this.updateHandshakeStatus(preResult);
        }
        int maxSize = Packet.calculateMaxData(dst.remaining());
        if (maxSize <= 0) {
            return this.updateHandshakeStatus((IEngineResult)Result.BUFFER_OVERFLOW);
        }
        ByteBuffer encoded = Packet.encode(this.offset, srcs, maxSize);
        int prevRemaining = dst.remaining();
        if (encoded != null) {
            consumed = encoded.limit() - 12;
            dst.put(encoded);
        } else {
            consumed = 0;
        }
        return new EngineResult(Status.OK, this.getHandshakeStatus(), consumed, prevRemaining - dst.remaining());
    }

    protected IEngineResult closeUnwrap(ByteBuffer dst) {
        return Result.CLOSED;
    }

    protected boolean isClosingUnwrap(byte[] data) {
        return false;
    }

    protected IEngineResult preUnwrap(ByteBuffer src, ByteBuffer dst) {
        if (this.inboundDone == AbstractEngine.CloseType.PENDING) {
            IEngineResult result = this.closeUnwrap(dst);
            if (result.getStatus() == Status.CLOSED) {
                this.inboundDone = AbstractEngine.CloseType.DONE;
            }
            return result;
        }
        if (this.inboundDone == AbstractEngine.CloseType.DONE) {
            return Result.CLOSED;
        }
        if (!this.finished) {
            this.finished = true;
            return Result.FINISHED;
        }
        return null;
    }

    public IEngineResult unwrap(ByteBuffer src, ByteBuffer dst) throws Exception {
        IEngineResult preResult = this.preUnwrap(src, dst);
        if (preResult != null) {
            return this.updateHandshakeStatus(preResult);
        }
        int size = Packet.decodeSize(this.offset, src);
        if (size == -1) {
            return this.updateHandshakeStatus((IEngineResult)Result.BUFFER_UNDERFLOW);
        }
        if (Packet.calculateMaxData(size) > dst.remaining()) {
            return this.updateHandshakeStatus((IEngineResult)Result.BUFFER_OVERFLOW);
        }
        int prevRemaining = src.remaining();
        byte[] decoded = Packet.decode(this.offset, src, size);
        if (this.isClosingUnwrap(decoded)) {
            this.inboundDone = AbstractEngine.CloseType.DONE;
            this.outboundDone = AbstractEngine.CloseType.PENDING;
            return this.updateHandshakeStatus((IEngineResult)Result.closedNeedWrap(prevRemaining - src.remaining()));
        }
        dst.put(decoded);
        return new EngineResult(Status.OK, this.getHandshakeStatus(), prevRemaining - src.remaining(), decoded.length);
    }
}

