/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.sctp.multi;

import com.sun.nio.sctp.Association;
import java.net.SocketAddress;
import java.util.Set;
import org.snf4j.core.handler.ISctpHandler;
import org.snf4j.core.session.ISctpMultiSession;
import org.snf4j.example.sctp.multi.AssociationContext;

class AssociationManager {
    final AssociationContext[] contexts;
    final ISctpHandler handler;

    AssociationManager(ISctpHandler handler, int maxCount, SocketAddress ... peers) {
        this.handler = handler;
        this.contexts = new AssociationContext[peers.length];
        for (int i = 0; i < peers.length; ++i) {
            this.contexts[i] = new AssociationContext(peers[i], maxCount);
        }
    }

    ISctpMultiSession getSession() {
        return (ISctpMultiSession)this.handler.getSession();
    }

    AssociationContext getContext(Association association) {
        Set addresses = this.getSession().getRemoteAddresses(association);
        for (int i = 0; i < this.contexts.length; ++i) {
            AssociationContext c = this.contexts[i];
            if (!addresses.contains(c.peer)) continue;
            return c;
        }
        throw new IllegalArgumentException(association.toString());
    }

    AssociationContext getContext(SocketAddress peer) {
        for (int i = 0; i < this.contexts.length; ++i) {
            AssociationContext c = this.contexts[i];
            if (!c.peer.equals(peer)) continue;
            return c;
        }
        throw new IllegalArgumentException(peer.toString());
    }
}

