/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.dtls;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import org.snf4j.core.DTLSSession;
import org.snf4j.core.DatagramSession;
import org.snf4j.core.SelectorLoop;
import org.snf4j.core.handler.IDatagramHandler;
import org.snf4j.example.dtls.SessionHandler;

public class DTLSClient {
    static final String PREFIX = "org.snf4j.";
    static final String HOST = System.getProperty("org.snf4j.Host", "127.0.0.1");
    static final int PORT = Integer.getInteger("org.snf4j.Port", 8001);
    static final int SECURE = Integer.getInteger("org.snf4j.Secure", 1);

    public static void main(String[] args) throws Exception {
        SelectorLoop loop = new SelectorLoop();
        try {
            loop.start();
            DatagramChannel channel = DatagramChannel.open();
            channel.configureBlocking(false);
            channel.connect(new InetSocketAddress(InetAddress.getByName(HOST), PORT));
            if (SECURE == 0) {
                loop.register(channel, (IDatagramHandler)new SessionHandler(true));
            } else {
                loop.register(channel, (DatagramSession)new DTLSSession((IDatagramHandler)new SessionHandler(true), true));
            }
            loop.join();
        }
        finally {
            loop.stop();
        }
    }
}

