/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.dtls;

import java.nio.ByteBuffer;
import java.util.Random;
import java.util.zip.CRC32;

class Packet {
    static final int CRC_SIZE = 8;
    static final Random RANDOM = new Random(System.currentTimeMillis());
    private final long sequence;
    private final byte[] bytes;

    Packet(long sequence, int size) {
        this.sequence = sequence;
        this.bytes = new byte[size];
        RANDOM.nextBytes(this.bytes);
        ByteBuffer b = ByteBuffer.wrap(this.bytes);
        CRC32 crc = new CRC32();
        b.clear();
        b.putInt(this.bytes.length);
        b.putLong(sequence);
        crc.update(this.bytes, 0, this.bytes.length - 8);
        b.position(this.bytes.length - 8);
        b.putLong(crc.getValue());
    }

    Packet(byte[] bytes) {
        this.bytes = bytes;
        ByteBuffer b = ByteBuffer.wrap(bytes);
        CRC32 crc = new CRC32();
        int size = b.getInt();
        if (size != bytes.length) {
            throw new IllegalArgumentException();
        }
        this.sequence = b.getLong();
        b.position(bytes.length - 8);
        long crcValue = b.getLong();
        crc.update(bytes, 0, bytes.length - 8);
        if (crcValue != crc.getValue()) {
            throw new IllegalArgumentException();
        }
    }

    long getSequence() {
        return this.sequence;
    }

    byte[] toBytes() {
        return this.bytes;
    }
}

