/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.echo;

import org.snf4j.core.allocator.IByteBufferAllocator;
import org.snf4j.core.allocator.ThreadLocalCachingAllocator;
import org.snf4j.core.factory.DefaultSessionStructureFactory;
import org.snf4j.core.factory.ISessionStructureFactory;
import org.snf4j.core.handler.AbstractStreamHandler;
import org.snf4j.core.handler.SessionIncident;
import org.snf4j.core.session.ISessionConfig;
import org.snf4j.example.echo.EchoClient;
import org.snf4j.example.echo.EchoServer;
import org.snf4j.example.echo.Logger;
import org.snf4j.example.echo.SessionConfig;

public class EchoServerHandler
extends AbstractStreamHandler {
    private static final IByteBufferAllocator ALLOCATOR = new ThreadLocalCachingAllocator(true);

    public void read(Object msg) {
        this.getSession().writenf(msg);
    }

    public void exception(Throwable e) {
        Logger.err(e.toString());
    }

    public boolean incident(SessionIncident incident, Throwable t) {
        Logger.err(incident + ": " + t.toString());
        return true;
    }

    public ISessionConfig getConfig() {
        return new SessionConfig(EchoServer.PIPELINE_SIZE).setOptimizeDataCopying(true).setMinOutBufferCapacity(EchoClient.SIZE << 1);
    }

    public ISessionStructureFactory getFactory() {
        return new DefaultSessionStructureFactory(){

            public IByteBufferAllocator getAllocator() {
                return ALLOCATOR;
            }
        };
    }
}

