/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.echo;

import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import org.snf4j.core.codec.DefaultCodecExecutor;
import org.snf4j.core.codec.ICodecExecutor;
import org.snf4j.core.codec.IDecoder;
import org.snf4j.core.codec.IEncoder;
import org.snf4j.core.session.DefaultSessionConfig;
import org.snf4j.core.session.SSLEngineCreateException;
import org.snf4j.example.echo.Decoder;
import org.snf4j.example.echo.Encoder;

public class SessionConfig
extends DefaultSessionConfig {
    static volatile SSLContext sslContext = null;
    private final int pipelineSize;

    SessionConfig(int pipelineSize) {
        this.pipelineSize = pipelineSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(KeyStore ks, String fileName, char[] password) throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
        try {
            ks.load(in, password);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSLContext getSSLContext() throws SSLEngineCreateException {
        if (sslContext == null) {
            try {
                Class<SessionConfig> clazz = SessionConfig.class;
                synchronized (SessionConfig.class) {
                    if (sslContext == null) {
                        KeyStore ks = KeyStore.getInstance("JKS");
                        KeyStore ts = KeyStore.getInstance("JKS");
                        char[] password = "password".toCharArray();
                        this.load(ks, "/keystore.jks", password);
                        this.load(ts, "/keystore.jks", password);
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                        kmf.init(ks, password);
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                        tmf.init(ts);
                        SSLContext ctx = SSLContext.getInstance("TLS");
                        ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                        sslContext = ctx;
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                throw new SSLEngineCreateException((Throwable)e);
            }
        }
        {
            return sslContext;
        }
    }

    public SSLEngine createSSLEngine(boolean clientMode) throws SSLEngineCreateException {
        SSLEngine engine = this.getSSLContext().createSSLEngine();
        engine.setUseClientMode(clientMode);
        if (!clientMode) {
            engine.setNeedClientAuth(true);
        }
        return engine;
    }

    public ICodecExecutor createCodecExecutor() {
        if (this.pipelineSize <= 0) {
            return null;
        }
        DefaultCodecExecutor executor = new DefaultCodecExecutor();
        for (int i = 0; i < this.pipelineSize; ++i) {
            executor.getPipeline().add((Object)("DECODER" + i), (IDecoder)new Decoder());
            executor.getPipeline().add((Object)("ENCODER" + i), (IEncoder)new Encoder());
        }
        return executor;
    }
}

