/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.engine;

import java.nio.ByteBuffer;
import org.snf4j.core.engine.HandshakeStatus;
import org.snf4j.core.engine.IEngine;
import org.snf4j.core.engine.IEngineResult;
import org.snf4j.core.handler.SessionIncidentException;

public abstract class AbstractEngine
implements IEngine {
    protected CloseType outboundDone = CloseType.NONE;
    protected CloseType inboundDone = CloseType.NONE;
    protected HandshakeStatus handshakeStatus = HandshakeStatus.NOT_HANDSHAKING;

    public void init() {
    }

    public void cleanup() {
    }

    public void beginHandshake() throws Exception {
    }

    public Object getSession() {
        throw new UnsupportedOperationException();
    }

    public boolean isOutboundDone() {
        return this.outboundDone != CloseType.NONE;
    }

    public boolean isInboundDone() {
        return this.inboundDone != CloseType.NONE;
    }

    public void closeOutbound() {
        this.outboundDone = CloseType.PENDING;
    }

    public void closeInbound() throws SessionIncidentException {
        this.inboundDone = CloseType.PENDING;
    }

    public int getMinApplicationBufferSize() {
        return 1012;
    }

    public int getMinNetworkBufferSize() {
        return 1024;
    }

    public int getMaxApplicationBufferSize() {
        return this.getMinApplicationBufferSize();
    }

    public int getMaxNetworkBufferSize() {
        return this.getMinNetworkBufferSize();
    }

    public HandshakeStatus getHandshakeStatus() {
        return this.handshakeStatus;
    }

    public Runnable getDelegatedTask() {
        return null;
    }

    public IEngineResult wrap(ByteBuffer src, ByteBuffer dst) throws Exception {
        return this.wrap(new ByteBuffer[]{src}, dst);
    }

    protected IEngineResult updateHandshakeStatus(IEngineResult result) {
        this.handshakeStatus = result.getHandshakeStatus() != HandshakeStatus.FINISHED ? result.getHandshakeStatus() : HandshakeStatus.NOT_HANDSHAKING;
        return result;
    }

    protected static enum CloseType {
        NONE,
        PENDING,
        DONE;

    }
}

