/*
 * Decompiled with CFR 0.152.
 */
package org.snf4j.example.engine;

import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.snf4j.core.SelectorLoop;
import org.snf4j.core.StreamSession;
import org.snf4j.core.factory.IStreamSessionFactory;
import org.snf4j.core.handler.IStreamHandler;
import org.snf4j.example.engine.EngineFactory;
import org.snf4j.example.engine.EngineServerHandler;
import org.snf4j.example.engine.EngineSession;

public class EngineServer {
    static final String PREFIX = "org.snf4j.";
    static final int PORT = Integer.getInteger("org.snf4j.Port", 8003);
    static final int ENGINE = Integer.getInteger("org.snf4j.Engine", 2);
    static final int OFFSET = Integer.getInteger("org.snf4j.Offset", 66);

    public static void main(String[] args) throws Exception {
        SelectorLoop loop = new SelectorLoop();
        try {
            loop.start();
            ServerSocketChannel channel = ServerSocketChannel.open();
            channel.configureBlocking(false);
            channel.socket().bind(new InetSocketAddress(PORT));
            loop.register(channel, new IStreamSessionFactory(){

                public StreamSession create(SocketChannel channel) throws Exception {
                    return new EngineSession(EngineFactory.create(ENGINE, OFFSET, false), (IStreamHandler)new EngineServerHandler());
                }

                public void registered(ServerSocketChannel channel) {
                }

                public void closed(ServerSocketChannel channel) {
                }

                public void exception(ServerSocketChannel channel, Throwable exception) {
                }
            });
            loop.join();
        }
        finally {
            loop.stop();
        }
    }
}

